<?php
// clear_db.php

require 'rb.php'; // or the path to your RedBeanPHP file

// Database configuration
$dbfile = 'mwalimu.db';

// Establish database connection
R::setup("sqlite:$dbfile");

// Check if connected
if (!R::testConnection()) {
    die('Failed to connect to the database.');
}

// Get all tables
$tables = R::inspect();

// Loop through each table and clear it
foreach ($tables as $table) {
    R::wipe($table);
    echo "Table '$table' cleared.\n";
}

echo "Database cleared successfully!";
