<?php
require 'rb.php';
R::setup('sqlite:mwalimu.db');

try {
    R::exec('DROP TABLE IF EXISTS school_list');

    R::exec('
        CREATE TABLE school_list (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            school_name TEXT NOT NULL,
            school_email TEXT NOT NULL UNIQUE,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )
    ');

    $schools = [
        ['school_name' => 'Test High School', 'school_email' => 'sample@high.edu'],
        ['school_name' => 'Test Academy', 'school_email' => 'example@academy.org'],
        ['school_name' => 'Test College', 'school_email' => 'test@college.com']
    ];

    foreach ($schools as $schoolData) {
        $school = R::dispense('school_list');
        $school->school_name = $schoolData['school_name'];
        $school->school_email = $schoolData['school_email'];
        R::store($school);
    }

    echo "Table 'school_list' recreated and populated successfully!";
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
