<?php
require_once 'class.phpmailer.php';
require_once 'class.smtp.php';

$messageSent = false;
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = trim($_POST['subject']);
    $body = trim($_POST['body']);
    $emails = explode("\n", trim($_POST['emails']));

    foreach ($emails as $email) {
        $email = trim($email);
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $errors[] = "Invalid email: $email";
            continue;
        }

        $mail = new PHPMailer();
        $mail->IsSMTP();
        $mail->Host = "mail.yourdomain.com"; // Set your SMTP server
        $mail->SMTPAuth = true;
        $mail->Username = "mr.bogibenda@gmail.com";  // SMTP username
        $mail->Password = "Kempo@725138";    // SMTP password
        $mail->Port = 587;                   // SMTP port
        $mail->SMTPSecure = 'tls';           // or '' if no encryption
        $mail->CharSet = 'UTF-8';

        $mail->SetFrom('themwalimulink@gmail.com', 'Mwalimu.info');
        $mail->AddAddress($email);
        $mail->Subject = $subject;
        $mail->MsgHTML(nl2br($body));
        $mail->AltBody = strip_tags($body);

        if (!$mail->Send()) {
            $errors[] = "Failed to send to $email: " . $mail->ErrorInfo;
        }
    }

    if (empty($errors)) {
        $messageSent = true;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Mwalimu Mass Mailer</title>
  <link rel="stylesheet" href="https://unpkg.com/@picocss/pico@1.*/css/pico.min.css">
</head>
<body>
<main class="container">
  <h2>📨 Mass Mailer — Mwalimu.info</h2>

  <?php if ($messageSent): ?>
    <article class="success">✅ All emails sent successfully!</article>
  <?php endif; ?>

  <?php if (!empty($errors)): ?>
    <article class="warning">
      <strong>Some errors occurred:</strong>
      <ul>
        <?php foreach ($errors as $error): ?>
          <li><?= htmlspecialchars($error) ?></li>
        <?php endforeach; ?>
      </ul>
    </article>
  <?php endif; ?>

  <form method="post">
    <label for="subject">Subject</label>
    <input type="text" name="subject" id="subject" required
      value="<?= isset($_POST['subject']) ? htmlspecialchars($_POST['subject']) : 'Join Mwalimu.info Today!' ?>">

    <label for="body">Message Body</label>
    <textarea name="body" id="body" rows="10" required><?= isset($_POST['body']) ? htmlspecialchars($_POST['body']) : "Dear Teacher,\n\nYou're warmly invited to join Mwalimu.info — Kenya’s smart teaching opportunities platform.\n\nSign up at https://mwalimu.info\n\nBest regards,\nMwalimu.info Team" ?></textarea>

    <label for="emails">Email List (one email per line)</label>
    <textarea name="emails" id="emails" rows="8" required><?= isset($_POST['emails']) ? htmlspecialchars($_POST['emails']) : '' ?></textarea>

    <button type="submit">Send Emails</button>
  </form>
</main>
</body>
</html>
