<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
/* Navigation Bar */
.nav {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1em;
    background-color: #f1f1f1; /* w3-light-grey */
    color: black;
    position: relative;
    /*font-family: Arial, sans-serif;*/
}

/* Logo & Motto */
.logo-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    line-height: 1.1;
}

.logo {
    font-family: "IM Fell English", serif;
    font-size: 40px;
    font-weight: bold;
}

.motto {
    font-family: "IM Fell English", serif;
    font-style: italic;
    font-size: 14px;
    color: #757575; /* Darker text color */
    margin-top: -5px;
}

.logo-container i {
    color: black;
    font-size: 40px;
    margin-right: 5px;
    vertical-align: middle;
}

/* Menu Links */
.menu-links {
    list-style: none;
    padding: 0;
    margin: 0;
    display: flex;
    background: #f1f1f1; /* w3-light-grey */
    justify-content: space-around;
    align-items: center;
}

.menu-links li {
    position: relative;
    padding: 10px;
}

.menu-links a {
    text-decoration: none;
    color: black;
    font-size: 18px;
    font-weight: bold;
    padding: 12px 20px;
    /*border-radius: 5px;*/
    transition: 0.3s;
    display: flex;
    align-items: center;
    gap: 5px;
}

/* Hover & Active Effects */
.menu-links a:hover {
    background: #757575;
    color: #fff;
}

.menu-links a.active {
    background: #ffcc00;
    color: #000;
    border-bottom: 3px solid #fff;
}

/* Dropdown styles */
.dropdown-content {
    display: none;
    position: absolute;
    background-color: #f1f1f1; /* w3-light-grey */
    min-width: 160px;
    box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
    z-index: 1;
}

.dropdown-content a {
    color: black;
    padding: 12px 16px;
    text-decoration: none;
    display: block;
    text-align: left;
}

.dropdown-content a:hover {
    background-color: #757575;
    color: #fff;
}

.dropdown:hover .dropdown-content {
    display: block;
}

/* Mobile Menu */
.menu-icon {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
}

.menu-icon span {
    display: block;
    width: 25px;
    height: 3px;
    background: black;
    transition: 0.3s;
}

#menu-btn {
    display: none;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .menu-links {
        display: none;
        flex-direction: column;
        width: 100%;
        position: absolute;
        top: 60px;
        left: 0;
        background: #f1f1f1; /* w3-light-grey */
    }

    .menu-links li {
        text-align: center;
        width: 100%;
        padding: 10px 0;
    }

    .menu-icon {
        display: flex;
    }

    #menu-btn:checked ~ .menu-links {
        display: flex;
    }

    .dropdown-content {
        position: static;
        display: none;
        width: 100%;
    }

    .dropdown.active .dropdown-content {
        display: block;
    }
}
</style>

<nav class="nav">
    <div class="logo-container">
        <div>
           <!-- <i class="fas fa-chalkboard-teacher"></i>--> 
            <span class="logo"><img src="mwalimu-link-logo-blank.png"><!--MwalimuLink<sup>&trade;</sup>--></span>
        </div>
        <!--<span class="motto"> Creating Opportunities </span>-->
    </div>

    <input type="checkbox" id="menu-btn">
    <label for="menu-btn" class="menu-icon">
        <span></span>
        <span></span>
        <span></span>
    </label>

    <ul class="menu-links">
        <li><a href="index.php?action=landing"><i class="fas fa-home"></i> Home</a></li>
        <li class="dropdown">
            <a href="#"><i class="fas fa-user"></i> Teacher</a>
            <div class="dropdown-content">
                <a href="index.php?action=teacher_register"><i class="fas fa-user-plus"></i> Register</a>
                <a href="index.php?action=teacher_login"><i class="fas fa-sign-in-alt"></i> Teacher Login</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="#"><i class="fas fa-school"></i> School</a>
            <div class="dropdown-content">
                <a href="index.php?action=school_register"><i class="fas fa-user-plus"></i> Register</a>
                <a href="index.php?action=school_login"><i class="fas fa-sign-in-alt"></i> School Login</a>
                <a href="index.php?action=school_subscribe"><i class="fas fa-envelope"></i> Subscribe</a>
            </div>
        </li>
        <li><a href="index.php?action=admin_login"><i class="fas fa-user-shield"></i> Admin Login</a></li>
        <li><a href="index.php?action=faq"><i class="fas fa-question-circle"></i> FAQ</a></li>
    </ul>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropdowns = document.querySelectorAll('.dropdown');
    
    dropdowns.forEach(dropdown => {
        dropdown.addEventListener('click', function(e) {
            if (window.innerWidth <= 768) {
                e.preventDefault();
                this.classList.toggle('active');
            }
        });
    });
});
</script>
