<?php // populate.php
require 'rb.php'; // Include RedBeanPHP

// Configure SQLite database
R::setup('sqlite:mwalimu.db');

// Generate 50 Schools
for ($i = 1; $i <= 50; $i++) {
    $school = R::dispense('school');
    $school->name = "School " . $i . " " . generate_kenyan_location();
    $school->email = "info@school{$i}.edu.ke";
    $school->password = password_hash('Kenya@254', PASSWORD_DEFAULT);
    $school->phone_number = '2547' . rand(10000000, 99999999);
    $school->address = "P.O Box " . rand(10000, 99999) . " " . generate_kenyan_location();
    $school->status = 'active';
    $school->subscription_expiry = null;
    R::store($school);
}

// Generate 50 Teachers with Kenyan names
$subjects = ['Math', 'English', 'Kiswahili', 'Science', 'History', 'Geography'];
$grades = ['Grade 1', 'Grade 4', 'Grade 5', 'Grade 6', 'Grade 7', 'Grade 8'];

for ($i = 1; $i <= 5000; $i++) {
    $teacher = R::dispense('teacher');
    $teacher->name = generate_kenyan_name();
    $teacher->password = password_hash('Kenya@254', PASSWORD_DEFAULT);
    $teacher->date_of_birth = rand(1970, 1995) . '-' . rand(1,12) . '-' . rand(1,28);
    $teacher->email = strtolower(str_replace(' ', '', $teacher->name)) . "@gmail.com";
    $teacher->phone_number = '07' . rand(20000000, 99999999);
    $teacher->teaching_subjects = implode(', ', array_rand(array_flip($subjects), 2));
    $teacher->grade_levels = $grades[array_rand($grades)];
    $teacher->years_of_experience = rand(1, 30);
    $teacher->degrees_obtained = 'BEd. ' . $subjects[array_rand($subjects)];
    $teacher->institutions_attended = ['University of Nairobi', 'Kenyatta University', 'Moi University'][rand(0,2)];
    $teacher->graduation_dates = (rand(2000, 2020)) . '-01-01';
    $teacher->teaching_certifications = 'TSC Certificate';
    $teacher->tsc_number = rand(1000, 9999);
    $teacher->county = ['Nairobi', 'Mombasa', 'Kisumu', 'Nakuru', 'Meru', ][rand(0,3)];
    $teacher->country = 'Kenya';
    R::store($teacher);
}

echo "Successfully added 5000 schools and 5000 teachers!";

// Helper functions
function generate_kenyan_name() {
    $first = ['John', 'Mary', 'James', 'Elizabeth', 'Peter', 'Grace', 'David', 'Esther', 'Paul', 'Lucy'];
    $last = ['Mwangi', 'Wanjiru', 'Omondi', 'Achieng', 'Kamau', 'Nyambura', 'Kipchoge', 'Wairimu', 'Maina', 'Chebet'];
    return $first[array_rand($first)] . ' ' . $last[array_rand($last)];
}
function generate_kenyan_location() {
    $counties = [
        'Mombasa', 'Kwale', 'Kilifi', 'Tana River', 'Lamu', 'Taita-Taveta', 'Garissa',
        'Wajir', 'Mandera', 'Marsabit', 'Isiolo', 'Meru', 'Tharaka-Nithi', 'Embu',
        'Kitui', 'Machakos', 'Makueni', 'Nyandarua', 'Nyeri', 'Kirinyaga', 'Murang\'a',
        'Kiambu', 'Turkana', 'West Pokot', 'Samburu', 'Trans-Nzoia', 'Uasin Gishu',
        'Elgeyo-Marakwet', 'Nandi', 'Baringo', 'Laikipia', 'Nakuru', 'Narok',
        'Kajiado', 'Kericho', 'Bomet', 'Kakamega', 'Vihiga', 'Bungoma', 'Busia',
        'Siaya', 'Kisumu', 'Homa Bay', 'Migori', 'Kisii', 'Nyamira', 'Nairobi'
    ];
    return $counties[array_rand($counties)];
}
/**
function generate_kenyan_location() {
    return ['Nairobi', 'Mombasa', 'Kisumu', 'Nakuru', 'Eldoret', 'Thika', 'Kitale', 'Meru', 'Nyeri', 'Machakos'][rand(0,9)];
}**/
