<?php
// setup_db.php

// Include RedBeanPHP
require 'rb.php';

// Database connection details (adjust as needed)
$db_host = 'localhost'; // or your database host
$db_name = 'mwalimu.db'; // Path to your SQLite database
$db_user = null; // No user for SQLite
$db_pass = null; // No password for SQLite

try {
    // Set up the database connection
    R::setup("sqlite:$db_name", $db_user, $db_pass);

    // Check if the connection was successful
    if (!R::testConnection()) {
        throw new Exception("Failed to connect to the database: " . R::getDatabase()->errorInfo()[2]);
    }

    // Check if the 'school' table exists; if not, create it (This part will only run if table is missing)
    if (!R::findLike('school', ['name' => ''])) {
        R::exec("CREATE TABLE IF NOT EXISTS school (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT,
            email TEXT,
            password TEXT,
            phone_number TEXT,
            address TEXT,
            status TEXT DEFAULT 'inactive',
            subscription_expiry DATETIME
        );");
        echo "<div class='w3-container w3-green'><h2>Table 'school' created successfully.</h2></div>";
    }
    else {
        echo "<div class='w3-container w3-yellow'><h2>Table 'school' already exists.</h2></div>";
    }

    // Check if the status and expiry columns exists and add them if they don't (Only run if column missing)
    $existingColumns = R::getAssoc("PRAGMA table_info(school)");
    $existingColumnNames = array_column($existingColumns, 'name');

    if (!in_array('status', $existingColumnNames)) {
        R::exec("ALTER TABLE school ADD COLUMN status TEXT DEFAULT 'inactive'");
        echo "<div class='w3-container w3-green'><h2>Column 'status' added to 'school' table successfully.</h2></div>";
    }
    else{
        echo "<div class='w3-container w3-yellow'><h2>Column 'status' already exists.</h2></div>";
    }

    if (!in_array('subscription_expiry', $existingColumnNames)) {
        R::exec("ALTER TABLE school ADD COLUMN subscription_expiry DATETIME");
        echo "<div class='w3-container w3-green'><h2>Column 'subscription_expiry' added to 'school' table successfully.</h2></div>";
    }
    else{
        echo "<div class='w3-container w3-yellow'><h2>Column 'subscription_expiry' already exists.</h2></div>";
    }

     // Create 'job' table if it doesn't exist (include school_id)
    if (!R::findLike('job', ['title' => ''])) {
        R::exec("CREATE TABLE IF NOT EXISTS job (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            school_id INTEGER,
            title TEXT,
            description TEXT,
            requirements TEXT,
            salary REAL,
            posted_date DATETIME,
            FOREIGN KEY (school_id) REFERENCES school(id)
        );");
        echo "<div class='w3-container w3-green'><h2>Table 'job' created successfully.</h2></div>";
    }
    else {
        echo "<div class='w3-container w3-yellow'><h2>Table 'job' already exists.</h2></div>";
    }

     // Create 'applications' table if it doesn't exist
    if (!R::findLike('applications', ['teacher_id' => ''])) {
        R::exec("CREATE TABLE IF NOT EXISTS applications (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            teacher_id INTEGER,
            job_id INTEGER,
            application_date DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (teacher_id) REFERENCES teacher(id),
            FOREIGN KEY (job_id) REFERENCES job(id)
        );");
        echo "<div class='w3-container w3-green'><h2>Table 'applications' created successfully.</h2></div>";
    }
    else {
        echo "<div class='w3-container w3-yellow'><h2>Table 'applications' already exists.</h2></div>";
    }

    echo "<div class='w3-container w3-green'><h2>Database setup complete!</h2></div>";

} catch (Exception $e) {
    echo "<div class='w3-container w3-red'><h2>Database setup failed:</h2><p>" . $e->getMessage() . "</p></div>";
}

?>

<link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
