<?php
// school_register.php

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Validate input data
        if (empty($_POST['name'])) {
            throw new Exception("School Name is required.");
        }
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
            throw new Exception("Invalid email address.");
        }
        if (!preg_match('/^2547[0-9]{8}$/', $_POST['phone_number'])) {
            throw new Exception("Invalid phone number format.");
        }
        if (strlen($_POST['password']) < 8) {
            throw new Exception("Password must be at least 8 characters long.");
        }

        // Store school details in the database
        $school = R::dispense('school');
        $school->name = htmlspecialchars($_POST['name']);
        $school->email = $_POST['email'];
        $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
        $school->county = htmlspecialchars($_POST['county']); // Changed address to county
        $school->status = 'inactive';
        $school->subscription_expiry = null; // or set a default expiry

        // Save school to database
        $id = R::store($school);

        $_SESSION['success'] = "Registration successful! Please wait for admin approval.";
        header('Location: /school_register.php');
        exit();

    } catch (Exception $e) {
        $_SESSION['error'] = "Error: " . htmlspecialchars($e->getMessage());
        header('Location: /school_register.php'); // Redirect to registration page
        exit();
    }
}
?>

<div class="w3-container w3-margin-top w3-center">
    <div class="w3-card-4 w3-white" style="max-width:600px; margin:20px auto;">
        <header class="w3-container w3-green">
            <h2>School Registration</h2>
        </header>

        <div class="w3-container w3-padding-16">
            <?php if (isset($_SESSION['success'])): ?>
                <div class="w3-panel w3-green w3-display-container">
                    <span onclick="this.parentElement.style.display='none'"
                          class="w3-button w3-large w3-display-topright">&times;</span>
                    <h3>Success!</h3>
                    <p><?= $_SESSION['success'] ?></p>
                </div>
                <?php unset($_SESSION['success']); ?>
            <?php endif; ?>

            <?php if (isset($_SESSION['error'])): ?>
                <div class="w3-panel w3-red w3-display-container">
                    <span onclick="this.parentElement.style.display='none'"
                          class="w3-button w3-large w3-display-topright">&times;</span>
                    <h3>Error!</h3>
                    <p><?= $_SESSION['error'] ?></p>
                </div>
                <?php unset($_SESSION['error']); ?>
            <?php endif; ?>

            <form method="POST" class="w3-container">
                <div class="w3-section">
                    <label for="name" class="w3-left-align">School Name</label>
                    <input type="text" id="name" name="name" class="w3-input w3-border" required>

                    <label for="email" class="w3-left-align">Email</label>
                    <input type="email" id="email" name="email" class="w3-input w3-border" required>

                    <label for="phone_number" class="w3-left-align">Phone Number (2547xxxxxxxxx)</label>
                    <input type="tel" id="phone_number" name="phone_number" class="w3-input w3-border"
                           pattern="2547[0-9]{8}" required>

                    <label for="county" class="w3-left-align">County</label>
                    <input type="text" id="county" name="county" class="w3-input w3-border" required> <!-- Changed address to county -->

                    <label for="password" class="w3-left-align">Password (min 8 characters)</label>
                    <input type="password" id="password" name="password" class="w3-input w3-border" required>

                    <button type="submit" class="w3-button w3-block w3-green w3-section w3-padding">
                        Register
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
