<?php
if (!isset($_SESSION['school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

// Simplified search (improve based on your requirements)
$teachers = R::findAll('teacher');

?>

<div class="w3-container w3-green">
    <h2>Search Candidates</h2>
</div>

<div class="w3-container">
    <h3>Available Teachers:</h3>

    <?php if (empty($teachers)): ?>
        <p>No teachers found.</p>
    <?php else: ?>
        <ul class="w3-ul">
            <?php foreach ($teachers as $teacher): ?>
                <li>
                    <strong><?php echo htmlspecialchars($teacher->name); ?></strong> -
                    <?php echo htmlspecialchars($teacher->teaching_subjects); ?> -
                    <a href="mailto:<?php echo htmlspecialchars($teacher->email); ?>">Contact</a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>
