<?php
// blog_admin.php - Admin Panel
////require_once 'includes/db.php';
////session_start();

// Authentication Check
if(!isset($_COOKIE['teacher_id'])) {
    header("Location:?action=login"); // Redirect to your auth system
    exit();
}

// CRUD Operations
if($_SERVER['METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;
    
    if(isset($_POST['delete'])) {
        $post = R::load('posts', $id);
        R::trash($post);
        $_SESSION['message'] = "Post deleted successfully";
    } else {
        $post = ($id > 0) ? R::load('posts', $id) : R::dispense('posts');
        
        $post->title = $_POST['title'];
        $post->slug = create_slug($_POST['title']); // Implement slug generation
        $post->content = $_POST['content'];
        $post->category_id = $_POST['category_id'];
        $post->author_id = $_COOKIE['teacher_id'];
        $post->is_published = isset($_POST['is_published']) ? 1 : 0;
        $post->updated_at = date('Y-m-d H:i:s');
        
        R::store($post);
        $_SESSION['message'] = "Post ".($id ? 'updated' : 'created')." successfully";
    }
    
    header("Location: /?action=blog_admin");
    exit();
}

// Fetch Data
$post = R::load('posts', $_GET['id'] ?? 0);
$categories = R::find('categories');
$posts = R::find('posts', 'ORDER BY created_at DESC LIMIT 100');

// Include WYSIWYG Editor
function include_wysiwyg() {
    echo <<<HTML
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js"></script>
    <script>
      tinymce.init({
        selector: '#content',
        plugins: 'link image code',
        toolbar: 'undo redo | bold italic | link image | code'
      });
    </script>
    HTML;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel</title>
    <?php include_wysiwyg(); ?>
</head>
<body>
    <h1>Admin Panel</h1>
    
    <!-- Edit Form -->
    <form method="post">
        <input type="hidden" name="id" value="<?= $post->id ?>">
        
        <label>Title: <input type="text" name="title" value="<?= htmlspecialchars($post->title) ?>" required></label>
        
        <label>Category:
            <select name="category_id" required>
                <?php foreach($categories as $cat): ?>
                    <option value="<?= $cat->id ?>" <?= ($post->category_id == $cat->id) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat->name) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </label>
        
        <label>Publish? <input type="checkbox" name="is_published" <?= $post->is_published ? 'checked' : '' ?>></label>
        
        <label>Content:</label>
        <textarea id="content" name="content" style="height:500px"><?= htmlspecialchars($post->content) ?></textarea>
        
        <button type="submit">Save</button>
        <?php if($post->id): ?>
            <button type="submit" name="delete" onclick="return confirm('Delete this post?')">Delete</button>
        <?php endif; ?>
    </form>

    <!-- Posts List -->
    <h2>Recent Posts</h2>
    <table>
        <?php foreach($posts as $p): ?>
            <tr>
                <td><?= date('Y-m-d', strtotime($p->created_at)) ?></td>
                <td><a href="?id=<?= $p->id ?>"><?= htmlspecialchars($p->title) ?></a></td>
                <td><?= $p->is_published ? 'Published' : 'Draft' ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
