<?php
// PDO connection
try {
    $pdo = new PDO('sqlite:../mwalimu.db'); // Update with your actual DB path
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Users array for authentication
$users = [
    'admin' => ['password' => 'Kenya@254', 'role' => 'admin'],
    'staff' => ['password' => 'Staff@123', 'role' => 'staff'],
];

$username = $_POST['username'] ?? $_GET['username'] ?? '';
$password = $_POST['password'] ?? $_GET['password'] ?? '';
$role = '';

// Authentication check
if (!isset($users[$username]) || $users[$username]['password'] !== $password) {
    echo <<<HTML
<form method="post">
    <h2>Login</h2>
    <label>Username: <input type="text" name="username" required></label><br>
    <label>Password: <input type="password" name="password" required></label><br>
    <button type="submit">Login</button>
</form>
HTML;
    exit();
}

$role = $users[$username]['role'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['title'], $_POST['content'])) {
    $title = $_POST['title'];
    $content = $_POST['content'];
    $category_id = (int)($_POST['category_id'] ?? 0);
    $is_published = isset($_POST['is_published']) ? 1 : 0;
    $post_id = (int)($_POST['id'] ?? 0);
    $created_at = date('Y-m-d H:i:s');
    $updated_at = date('Y-m-d H:i:s');
    $author = $username;

    if ($post_id == 0) {
        // Insert new post
        $sql = "INSERT INTO posts (title, content, category_id, is_published, created_at, updated_at, author) 
                VALUES (:title, :content, :category_id, :is_published, :created_at, :updated_at, :author)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':title' => $title,
            ':content' => $content,
            ':category_id' => $category_id,
            ':is_published' => $is_published,
            ':created_at' => $created_at,
            ':updated_at' => $updated_at,
            ':author' => $author,
        ]);
        $message = 'Post created successfully!';
    } else {
        // Update existing post
        $sql = "UPDATE posts SET 
                title = :title, content = :content, category_id = :category_id, 
                is_published = :is_published, updated_at = :updated_at, author = :author
                WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':title' => $title,
            ':content' => $content,
            ':category_id' => $category_id,
            ':is_published' => $is_published,
            ':updated_at' => $updated_at,
            ':author' => $author,
            ':id' => $post_id,
        ]);
        $message = 'Post updated successfully!';
    }
}

// Delete post
if (isset($_POST['delete']) && $role === 'admin') {
    $post_id = (int)($_POST['id'] ?? 0);
    $sql = "DELETE FROM posts WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $post_id]);
    $message = 'Post deleted successfully!';
}

// Fetch posts
$sql = "SELECT * FROM posts ORDER BY created_at DESC LIMIT 100";
$stmt = $pdo->query($sql);
$posts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch categories
$sql = "SELECT * FROM categories";
$stmt = $pdo->query($sql);
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel</title>
</head>
<body>
<h1>Welcome, <?= htmlspecialchars($username) ?>!</h1>
<p>Role: <?= htmlspecialchars($role) ?></p>

<?php if (!empty($message)): ?>
    <div style="background: #cfc; padding: 0.5rem; margin: 1rem 0;">
        <?= htmlspecialchars($message) ?>
    </div>
<?php endif; ?>

<!-- Post form -->
<form method="post">
    <input type="hidden" name="username" value="<?= htmlspecialchars($username) ?>">
    <input type="hidden" name="id" value="<?= $post_id ?>">

    <label>Title:
        <input type="text" name="title" value="<?= htmlspecialchars($title ?? '') ?>" required>
    </label><br>

    <label>Category:
        <select name="category_id" required>
            <?php foreach ($categories as $cat): ?>
                <option value="<?= $cat['id'] ?>" <?= ($category_id == $cat['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($cat['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Publish?
        <input type="checkbox" name="is_published" <?= ($is_published) ? 'checked' : '' ?>>
    </label><br>

    <label>Content:<br>
        <textarea name="content" rows="10" cols="80"><?= htmlspecialchars($content ?? '') ?></textarea>
    </label><br>

    <button type="submit">Save Post</button>

    <?php if ($post_id): ?>
        <button type="submit" name="delete" onclick="return confirm('Delete this post?')">Delete</button>
    <?php endif; ?>
</form>

<!-- Post List -->
<h2>Recent Posts</h2>
<ul>
<?php foreach ($posts as $p): ?>
    <li>
        <strong><?= htmlspecialchars($p['title']) ?></strong> - 
        <a href="?id=<?= $p['id'] ?>&username=<?= urlencode($username) ?>&password=<?= urlencode($password) ?>">Edit</a>
    </li>
<?php endforeach; ?>
</ul>

</body>
</html>
