<?php
// international_school_add.php (pure PDO, no RedBeanPHP)

$error = "";
$success = "";

// --- PDO connection ---
try {
    $pdo = new PDO('sqlite:mwalimu.db');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("Database connection failed: " . $e->getMessage());
}

// --- TABLE CREATION LOGIC (optional, remove if table already exists) ---
try {
    $exists = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='international_school'")->fetchColumn();
    if (!$exists) {
        $pdo->exec("CREATE TABLE international_school (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            city TEXT NOT NULL,
            country TEXT NOT NULL,
            address TEXT NOT NULL
        )");
    }
} catch (Exception $e) {
    $error = 'Table creation error: ' . $e->getMessage();
}

// --- HANDLE FORM SUBMISSION ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'city' => trim($_POST['city'] ?? ''),
            'country' => trim($_POST['country'] ?? ''),
            'address' => trim($_POST['address'] ?? ''),
        ];

        // Validate required fields
        foreach ($data as $field => $value) {
            if (empty($value)) {
                throw new Exception("Field " . ucfirst($field) . " is required.");
            }
        }

        // Insert into database using parameterized query
        $columns = implode(', ', array_keys($data));
        $placeholders = ':' . implode(', :', array_keys($data));
        $sql = "INSERT INTO international_school ($columns) VALUES ($placeholders)";
        $stmt = $pdo->prepare($sql);

        foreach ($data as $key => $value) {
            $stmt->bindValue(':' . $key, $value, PDO::PARAM_STR);
        }

        if ($stmt->execute()) {
            $success = "School added successfully!";
            $_POST = []; // Clear form inputs
        } else {
            throw new Exception("Failed to save school record.");
        }
    } catch (Exception $e) {
        $error = "Error: " . $e->getMessage();
    }
}
?>
<style>
    body { font-family: Arial, sans-serif; margin: 2em; }
    .form-container { max-width: 500px; margin: auto; }
    .form-group { margin-bottom: 1em; }
    label { display: block; margin-bottom: 0.5em; font-weight: bold; }
    input { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; }
    .error { color: red; margin: 1em 0; padding: 1em; border: 1px solid red; }
    .success { color: green; margin: 1em 0; padding: 1em; border: 1px solid green; }
    button { padding: 8px 20px; cursor: pointer; }
</style>

<div class="form-container">
    <h2>Add New International School</h2>
    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <div class="form-group">
            <label>Name <span style="color:red">*</span></label>
            <input type="text" name="name" required value="<?= htmlspecialchars($_POST['name'] ?? '') ?>" />
        </div>
        <div class="form-group">
            <label>City <span style="color:red">*</span></label>
            <input type="text" name="city" required value="<?= htmlspecialchars($_POST['city'] ?? '') ?>" />
        </div>
        <div class="form-group">
            <label>Country <span style="color:red">*</span></label>
            <input type="text" name="country" required value="<?= htmlspecialchars($_POST['country'] ?? '') ?>" />
        </div>
        <div class="form-group">
            <label>Address <span style="color:red">*</span></label>
            <input type="text" name="address" required value="<?= htmlspecialchars($_POST['address'] ?? '') ?>" />
        </div>
        <button type="submit">Add School</button>
    </form>
</div>
