<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<?php
// Assumes RedBeanPHP is already set up and connected.

function h($str) { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }

$per_page = 10;
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

$where = '';
$params = [];
if ($search !== '') {
    $where = "WHERE name LIKE ? OR city LIKE ? OR country LIKE ? OR address LIKE ?";
    $params = array_fill(0, 4, "%$search%");
}

$total = $where
    ? R::count('international_school', $where, $params)
    : R::count('international_school');
$offset = ($page - 1) * $per_page;

$records = $where
    ? R::findAll('international_school', "$where ORDER BY name LIMIT ? OFFSET ?", array_merge($params, [$per_page, $offset]))
    : R::findAll('international_school', "ORDER BY name LIMIT ? OFFSET ?", [$per_page, $offset]);

function paginate($total, $per_page, $page, $base_url) {
    $pages = max(1, ceil($total / $per_page));
    echo '<nav aria-label="Pagination"><ul style="list-style:none; display:flex; gap:0.5rem; padding:0;">';
    echo $page > 1
        ? '<li><a href="' . h($base_url) . '&page=1">First</a></li>'
        : '<li style="opacity:0.5;">First</li>';
    echo $page > 1
        ? '<li><a href="' . h($base_url) . '&page=' . ($page - 1) . '">Prev</a></li>'
        : '<li style="opacity:0.5;">Prev</li>';
    echo '<li>Page ' . $page . ' of ' . $pages . ' (Total: ' . $total . ')</li>';
    echo $page < $pages
        ? '<li><a href="' . h($base_url) . '&page=' . ($page + 1) . '">Next</a></li>'
        : '<li style="opacity:0.5;">Next</li>';
    echo $page < $pages
        ? '<li><a href="' . h($base_url) . '&page=' . $pages . '">Last</a></li>'
        : '<li style="opacity:0.5;">Last</li>';
    echo '</ul></nav>';
}
?>

<form method="get" style="display:flex; gap:1rem; margin-bottom:1rem; align-items:center;">
    <input type="hidden" name="action" value="international_school_search" />
    <input type="search" name="search" value="<?=h($search)?>" placeholder="Search name, city, country, address..." style="flex:1; min-width:700px;" />
    <button type="submit">Search</button>
    <?php if ($search !== ''): ?>
        <a href="?">Clear</a>
    <?php endif; ?>
</form>

<?php if ($total === 0): ?>
    <p>No international schools found.</p>
<?php else: ?>
    <table border="1" cellpadding="5" cellspacing="0" style="width:100%; border-collapse:collapse;">
        <thead>
            <tr>
                <th>Name</th><th>City</th><th>Country</th><th>Address</th><th>Details</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($records as $rec): ?>
            <tr>
                <td><a href="?action=international_school_details&id=<?=$rec->id?>"><?=h($rec->name)?></a></td>
                <td><?=h($rec->city)?></td>
                <td><?=h($rec->country)?></td>
                <td><?=h($rec->address)?></td>
                <!--https://www.google.com/maps/search/?api=1&query=schoolname,city,country-->
                <td><a href="https://www.google.com/search?q=<?=urlencode($rec->name)?>,<?=urlencode($rec->city)?>,<?=urlencode($rec->country)?>" target="_blank">Locate </a></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<!-- https://mwalimu.info/?action=international_school_search&page=31 -->
    <?php
    $base_url = "?action=international_school_search" . urlencode($search);
    paginate($total, $per_page, $page, $base_url);
    ?>
<?php endif; ?>
