<?php
// Start the session
//session_start();

// Destroy all session variables
session_unset();

// Destroy the session
session_destroy();

// Check if there are any cookies set
if (isset($_SERVER['HTTP_COOKIE'])) {
    // Get all cookies as an array
    $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
    
    // Loop through each cookie
    foreach ($cookies as $cookie) {
        // Split the cookie into name and value
        $parts = explode('=', $cookie);
        $name = trim($parts[0]);
        
        // Expire the cookie by setting its expiration time to a past date
        setcookie($name, '', time() - 3600); // Expire without path
        setcookie($name, '', time() - 3600, '/'); // Expire with path
    }
}

// Confirmation message
echo "<H1>All cookies have been cleared. You have Successfully logged out <a href='Location: index.php?action=landing'>click here to continue</a></H1>";
// Redirect to the login page
header('Location: index.php?action=landing');
exit();
