<?php
// views/pay_subscription.php

// Check if the school is logged in via cookies
if (!isset($_COOKIE['school_id']) && !isset($_COOKIE['new_school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

// Validate and get school ID from cookies
$school_id = isset($_COOKIE['school_id']) ? 
    filter_var($_COOKIE['school_id'], FILTER_VALIDATE_INT) : 
    filter_var($_COOKIE['new_school_id'], FILTER_VALIDATE_INT);

if (!$school_id) {
    echo "<div class='container'><h2>Error</h2><p>Invalid school ID.</p></div>";
    exit();
}

// Fetch the school details
$school = R::load('school', $school_id);
if (!$school->id) {
    echo "<div class='container'><h2>Error</h2><p>School not found.</p></div>";
    exit();
}

// If the form is submitted, process the payment request
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // IntaSend API credentials
    $public_key = "ISPubKey_live_40f25458-716c-47c5-b049-786fd1f3a1ce";

    // Payment details
    $amount = 12; // Subscription amount (KES 12)
    $currency = "KES";
    $host = "http://mwalimu.info"; // Your base URL
    $redirect_url = $host . "/index.php?action=subscription_callback"; // Callback URL
    $api_ref = "MwalimuLink_School_Subscription_" . $school->id;  // Unique reference

    // Sanitize the school name to remove invalid characters
    $school_name = preg_replace('/[^a-zA-Z0-9\\s\\-\\_]/', '', $school->name);

    // API request payload
    $data = [
        "public_key" => $public_key,
        "amount" => $amount,
        "currency" => $currency,
        "api_ref" => $api_ref,
        "redirect_url" => $redirect_url,
        "first_name" => $school_name, // Use the sanitized name
        "last_name" => "", // You can leave this blank
        "email" => $school->email,
        "phone" => $school->phone_number,
        "country" => "KE"
    ];

    // Initialize cURL session
    $ch = curl_init("https://payment.intasend.com/api/v1/checkout/");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);

    // Execute the request
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Decode JSON response
    $responseData = json_decode($response, true);

    // Redirect if successful
    if ($http_code == 201 && isset($responseData['url'])) {
        header("Location: " . $responseData['url']);
        exit();
    } else {
        echo "<div class='container'><h2>Payment Error</h2><p>HTTP $http_code - " . json_encode($responseData) . "</p></div>";
    }
}
?>


    <article class="card" style="max-width: 80%; margin: 2rem auto;">
        <header>
            <hgroup>
                <h1>School Subscription</h1>
                <p>Kindly settle the subscription fee to activate your account.</p>
            </hgroup>
        </header>

        <figure>
            <img src="payment.jpg" alt="Payment Illustration">
            <figcaption>Secure and fast payment processing.</figcaption>
        </figure>

        <form method="post">
            <button type="submit" class="contrast">Pay Now (KES 12)</button>
        </form>
        
        <footer>
            <small>&copy; 2025 Mwalimu Link. All Rights Reserved.</small>
        </footer>
    </article>

