<?php
// public_school_detail.php

// --- CONFIGURATION ---
$db_file = 'mwalimu.db'; // Adjust path as needed

// --- GET SCHOOL ID ---
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// --- DB CONNECTION ---
$db = new PDO('sqlite:' . $db_file);

// --- FETCH SCHOOL ---
$stmt = $db->prepare("SELECT * FROM public_school WHERE id = ?");
$stmt->execute([$id]);
$school = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$school) {
    echo "<h2>School not found.</h2>";
    exit;
}
?>

    <title><?= htmlspecialchars($school['name']) ?> - School Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <style>
        #map { height: 350px; width: 100%; margin: 1em 0; }
        body { font-family: Arial, sans-serif; margin: 2em; }
        table { border-collapse: collapse; }
        td, th { padding: 8px 12px; border: 1px solid #ddd; }
        th { background: #f0f0f0; }
    </style>

    <h2><?= htmlspecialchars($school['name']) ?></h2>
    <table>
        <tr><th>Level</th><td><?= htmlspecialchars($school['level']) ?></td></tr>
        <tr><th>Status</th><td><?= htmlspecialchars($school['status']) ?></td></tr>
        <tr><th>County</th><td><?= htmlspecialchars($school['county']) ?></td></tr>
        <tr><th>Constituency</th><td><?= htmlspecialchars($school['constituency']) ?></td></tr>
        <tr><th>Ward</th><td><?= htmlspecialchars($school['ward']) ?></td></tr>
        <tr><th>Code</th><td><?= htmlspecialchars($school['code']) ?></td></tr>
        <tr><th>Email</th><td><?= htmlspecialchars($school['email']) ?></td></tr>
        <tr><th>Phone</th><td><?= htmlspecialchars($school['phone']) ?></td></tr>
        <tr><th>Address</th><td><?= htmlspecialchars($school['address']) ?></td></tr>
        <tr><th>Latitude</th><td><?= htmlspecialchars($school['latitude']) ?></td></tr>
        <tr><th>Longitude</th><td><?= htmlspecialchars($school['longitude']) ?></td></tr>
    </table>

    <?php if ($school['latitude'] && $school['longitude']): ?>
    <h3>Location Map</h3>
    <div id="map"></div>
    <?php else: ?>
    <p><em>No map location available for this school.</em></p>
    <?php endif; ?>

    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <?php if ($school['latitude'] && $school['longitude']): ?>
    <script>
        var lat = <?= floatval($school['latitude']) ?>;
        var lon = <?= floatval($school['longitude']) ?>;
        var map = L.map('map').setView([lat, lon], 16);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors'
        }).addTo(map);
        L.marker([lat, lon]).addTo(map)
            .bindPopup("<?= htmlspecialchars(addslashes($school['name'])) ?>")
            .openPopup();
    </script>
    <?php endif; ?>

