<?php
// public_school_search.php

// --- CONFIGURATION ---
$db_file = 'mwalimu.db'; // Adjust path as needed
$per_page = 20;

// --- GET PARAMETERS ---
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

// --- DB CONNECTION ---
$db = new PDO('sqlite:' . $db_file);

// --- BUILD QUERY ---
$where = '';
$params = [];
if ($search !== '') {
    $where = "WHERE name LIKE :search OR county LIKE :search OR constituency LIKE :search";
    $params[':search'] = "%$search%";
}

// --- COUNT FOR PAGINATION ---
$count_sql = "SELECT COUNT(*) FROM public_school $where";
$stmt = $db->prepare($count_sql);
$stmt->execute($params);
$total = $stmt->fetchColumn();
$total_pages = max(1, ceil($total / $per_page));

// --- FETCH SCHOOLS ---
$offset = ($page - 1) * $per_page;
$sql = "SELECT * FROM public_school $where ORDER BY name LIMIT :per_page OFFSET :offset";
$stmt = $db->prepare($sql);
foreach ($params as $k => $v) $stmt->bindValue($k, $v, PDO::PARAM_STR);
$stmt->bindValue(':per_page', $per_page, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$schools = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

    <style>
        body { font-family: Arial, sans-serif; margin: 2em; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ccc; padding: 8px; }
        th { background: #f8f8f8; }
        .pagination { margin: 1em 0; }
        .pagination a, .pagination span { margin: 0 2px; padding: 4px 8px; text-decoration: none; }
        .pagination .current { font-weight: bold; background: #ddd; }
        form { margin-bottom: 1em; }
    </style>

    <h2>Search Public Schools</h2>
    <form method="get" action="public_school_search.php">
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Search by name, county, or constituency">
        <button type="submit">Search</button>
    </form>

    <p>Showing <?= count($schools) ?> of <?= $total ?> schools<?= $search ? " for <b>".htmlspecialchars($search)."</b>" : "" ?>.</p>

    <table>
        <tr>
            <th>Name</th>
            <th>Level</th>
            <th>Status</th>
            <th>County</th>
            <th>Constituency</th>
            <th>Ward</th>
            <th>Code</th>
        </tr>
        <?php foreach ($schools as $school): ?>
        <tr>
            <td>
                <a href="public_school_detail.php?id=<?= urlencode($school['id']) ?>">
                    <?= htmlspecialchars($school['name']) ?>
                </a>
            </td>
            <td><?= htmlspecialchars($school['level']) ?></td>
            <td><?= htmlspecialchars($school['status']) ?></td>
            <td><?= htmlspecialchars($school['county']) ?></td>
            <td><?= htmlspecialchars($school['constituency']) ?></td>
            <td><?= htmlspecialchars($school['ward']) ?></td>
            <td><?= htmlspecialchars($school['code']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?search=<?= urlencode($search) ?>&page=<?= $page-1 ?>">&laquo; Prev</a>
        <?php endif; ?>
        <?php for ($p = 1; $p <= $total_pages; $p++): ?>
            <?php if ($p == $page): ?>
                <span class="current"><?= $p ?></span>
            <?php elseif ($p == 1 || $p == $total_pages || abs($p - $page) <= 2): ?>
                <a href="?search=<?= urlencode($search) ?>&page=<?= $p ?>"><?= $p ?></a>
            <?php elseif ($p == $page - 3 || $p == $page + 3): ?>
                ...
            <?php endif; ?>
        <?php endfor; ?>
        <?php if ($page < $total_pages): ?>
            <a href="?search=<?= urlencode($search) ?>&page=<?= $page+1 ?>">Next &raquo;</a>
        <?php endif; ?>
    </div>
