<?php
// Check if the session is not started yet
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

echo "<p>School ID: <strong>" . htmlspecialchars($_SESSION['school_id']) . "</strong></p>";
echo '<pre>';
print_r($_SESSION);
echo '</pre>';

if (!isset($_SESSION['school_id'])) {
    //header('Location: index.php?action=school_login');
    //echo '<meta http-equiv="refresh" content="0;url=index.php?action=school_login">';
    echo 'SESSION NOT SET ... setting it from get variable';
    $_SESSION['school_id']=$_GET['school_id'];
    exit();
}

$school_id = $_SESSION['school_id'];
$school_name = $_SESSION['school_name'];

$school = R::load('school', $school_id);

// Check if the subscription is active and not expired
$now = new DateTime();

// Validate subscription_expiry before creating a DateTime object
if (!empty($school->subscription_expiry)) {
    $expiry_date = new DateTime($school->subscription_expiry);
} else {
    // Handle null or empty subscription_expiry (e.g., set a default or redirect)
    $expiry_date = new DateTime('1970-01-01'); // Default to an old date for safety
}

// Check subscription status and expiry date
if ($school->status !== 'active' || $expiry_date < $now) {
    // Subscription is inactive or expired - redirect to payment page
    header('Location: index.php?action=pay_subscription');
    exit();
}
?>

<div class="w3-container w3-green">
    <h2>School Dashboard</h2>
</div>

<div class="w3-container">
    <h3>Welcome, <?php echo htmlspecialchars($school_name); ?>!</h3>

    <a href="index.php?action=school_post_job" class="w3-button w3-blue">Post a Job</a><br><br>
    <a href="index.php?action=school_search_candidate" class="w3-button w3-blue">Search Candidates</a><br><br>
    <a href="index.php?action=logout" class="w3-button w3-red">Logout</a>
</div>

<?php
/**
if (!isset($_SESSION['school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

$school_id = $_SESSION['school_id'];
$school_name = $_SESSION['school_name'];

$school = R::load('school', $school_id);

// Check if the subscription is active and not expired
$now = new DateTime();
$expiry_date = new DateTime($school->subscription_expiry);

if ($school->status !== 'active' || $expiry_date < $now) {
    // Subscription is inactive or expired - redirect to payment page
    header('Location: index.php?action=pay_subscription');
    exit();
}
**/
?>

<!--<div class="w3-container w3-green">
    <h2>School Dashboard</h2>
</div>

<div class="w3-container">
    <h3>Welcome, <?php echo htmlspecialchars($school_name); ?>!</h3>

    <a href="index.php?action=school_post_job" class="w3-button w3-blue">Post a Job</a><br><br>
    <a href="index.php?action=school_search_candidate" class="w3-button w3-blue">Search Candidates</a><br><br>
    <a href="index.php?action=logout" class="w3-button w3-red">Logout</a>
</div>-->
