<?php
// views/school_login.php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check if email exists
        $school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if (!$school) {
            throw new Exception("School does not exist.");
        }

        // Check if password matches
        if (!password_verify($_POST['password'], $school->password)) {
            throw new Exception("Incorrect password.");
        }

        // Set cookie variables
        // Note: This is insecure for sensitive data. Consider using sessions or tokens for security.
        setcookie('school_id', $school->id, time() + 3600); // expires in 1 hour
        setcookie('school_name', $school->name, time() + 3600); // expires in 1 hour

        // Redirect to school dashboard using PHP header
        header('Location: ./index.php?action=school_dashboard');
        exit();
    } catch (Exception $e) {
        $error_message = $e->getMessage();
    }
} elseif (!isset($_COOKIE['school_id'])) {
    // If cookie variable is not set, show a message
   // $error_message = "Cookie expired or invalid. Please log in again.";
   // $error_message = "Kindly log in.";
    $error_message = "...";
}
?>

<!-- Linking to the locally stored pico.cyan.min.css file -->
<link rel="stylesheet" href="pico.cyan.min.css">

<div class="container">
    <h1>School Login</h1>

    <?php if (isset($error_message)): ?>
        <p style="color: grey;"><?= htmlspecialchars($error_message) ?></p>
    <?php endif; ?>

    <form method="POST">
        <fieldset>
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>

            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Login</button>
        </fieldset>
    </form>

    <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>
</div>
