<?php
// views/school_login.php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check if email exists
        $school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if (!$school) {
            throw new Exception("School does not exist.");
        }

        // Check if password matches
        if (!password_verify($_POST['password'], $school->password)) {
            throw new Exception("Incorrect password.");
        }

        // Set cookie variables
        // Note: This is insecure for sensitive data. Consider using sessions or tokens for security.
        setcookie('school_id', $school->id, time() + 3600); // expires in 1 hour
        setcookie('school_name', $school->name, time() + 3600); // expires in 1 hour

        // Redirect to school dashboard using PHP header
        header('Location: ./index.php?action=school_dashboard');
        exit();
    } catch (Exception $e) {
        $error_message = $e->getMessage();
    }
} elseif (!isset($_COOKIE['school_id'])) {
    // If cookie variable is not set, show a message
    $error_message = "";
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>School Login</h2>
    </header>

    <?php if (isset($error_message)): ?>
        <div class="alert alert-error">
            <h4><?php echo htmlspecialchars($error_message); ?></h4>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="grid">
            <input type="email" id="email" placeholder="Email" name="email" required>
        </div>

        <div class="grid">
            <input type="password" placeholder="Password" id="password" name="password" required>
        </div>

        <button type="submit">Login</button>
    </form>

    <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>
</article>
<p>&nbsp;</p>