<?php
if (!isset($_COOKIE['school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

$school_id = $_COOKIE['school_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $requirements = $_POST['requirements'];
    $salary = $_POST['salary'];

    $job = R::dispense('job');
    $job->school_id = $school_id;
    $job->title = $title;
    $job->description = $description;
    $job->requirements = $requirements;
    $job->salary = $salary;
    $job->posted_date = R::isoDateTime();  // Current timestamp

    R::store($job);

    echo "<div class='w3-container w3-green'><h2><i class='fas fa-check-circle'></i> Job Posted Successfully!</h2></div>";
}
?>

<div class="w3-container w3-green">
    <h2><i class="fas fa-briefcase"></i> Post a Job</h2>
    <a href="index.php?action=school_dashboard" class="w3-button w3-light-grey w3-margin-top">
        <i class="fas fa-arrow-left"></i> Back to Dashboard
    </a>
</div>

<div class="w3-container w3-card w3-margin-top w3-padding-large w3-round-large" style="max-width: 600px; margin: auto;">
    <form method="POST" action="" class="w3-container">
        <h3><i class="fas fa-info-circle"></i> Job Details</h3>
        
        <!-- Job Title -->
        <label><i class="fas fa-heading"></i> Job Title:</label>
        <input type="text" name="title" required class="w3-input w3-border w3-round"><br>

        <!-- Job Description -->
        <label><i class="fas fa-align-left"></i> Job Description:</label>
        <textarea name="description" required class="w3-input w3-border w3-round"></textarea><br>

        <!-- Requirements -->
        <label><i class="fas fa-list-alt"></i> Requirements:</label>
        <textarea name="requirements" required class="w3-input w3-border w3-round"></textarea><br>

        <!-- Salary -->
        <label><i class="fas fa-dollar-sign"></i> Salary:</label>
        <input type="number" name="salary" required class="w3-input w3-border w3-round"><br>

        <!-- Submit Button -->
        <button type="submit" class="w3-button w3-blue w3-round-large">
            <i class="fas fa-paper-plane"></i> Post Job
        </button>
    </form>
</div><br/><br/>
