<?php
// school_register.php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        if (empty($_POST['name'])) throw new Exception("School Name is required.");
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) throw new Exception("Invalid email address.");
        if (!preg_match('/^2547[0-9]{8}$/', $_POST['phone_number'])) throw new Exception("Invalid phone number format (expecting 2547xxxxxxxx).");
        if (empty($_POST['county'])) throw new Exception("County is required.");
        if (empty($_POST['country'])) throw new Exception("Country is required.");
        if (strlen($_POST['password']) < 8) throw new Exception("Password must be at least 8 characters.");
        if (!isset($_POST['terms']) || $_POST['terms'] != '1') throw new Exception("You must accept the Terms and Conditions and Privacy Policy.");

        // Check if email already exists
        $existing_school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if ($existing_school) {
            $message = '⚠️ This email is already registered. <a href="index.php?action=reset_school_password&email=' . htmlspecialchars($_POST['email']) . '">Reset password?</a>';
            $showForm = false; // Prevent registration
        } else {

            $school = R::dispense('school');
            $school->name = htmlspecialchars($_POST['name']);
            $school->email = $_POST['email'];
            $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
            $school->county = htmlspecialchars($_POST['county']);
            $school->country = htmlspecialchars($_POST['country']);
            $school->status = 'inactive';
            $school->subscription_expiry = null;

            $school_id = R::store($school);
            $school_name = $school->name;

            setcookie('school_id', $school_id, time() + 86400, "/");
            setcookie('school_name', $school_name, time() + 86400, "/");

            echo "<p>Registration successful!</p>";
            echo "<p>School: <strong>" . htmlspecialchars($school_name) . "</strong> | ID: <strong>" . htmlspecialchars($school_id) . "</strong></p>";
            echo "<p>Redirecting to Subscription...</p>";
            echo '<script>setTimeout(() => { window.location.href = "./index.php?action=pay_subscription"; }, 5000);</script>';
            exit;
        }
    } catch (Exception $e) {
        echo "<p>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        echo "<p><a href='?action=school_register'>Try Again</a></p>";
        exit;
    }
}
?>

<article class="card" style="max-width: 60%; margin: 2rem auto;">
    <header>
        <h3 style="text-align: center;">School Registration</h3>
    </header>

    <form method="POST" style="padding: 1rem;">
        <label for="name">School Name
            <input type="text" id="name" name="name" required>
        </label>

        <label for="email">Email
            <input type="email" id="email" name="email" required>
        </label>

        <label for="phone_number">Phone Number
            <input type="tel" id="phone_number" name="phone_number" pattern="2547[0-9]{8}"
                placeholder="254xxxxxxxxx" required>
        </label>

        <label for="county">County
            <input type="text" id="county" name="county" required>
        </label>

        <label for="country">Country
        <input type="text" id="country" name="country" placeholder="Kenya" required>
        
            <!--<select id="country" name="country" required>
                <option value="Kenya" selected>Kenya</option>
                <option value="Uganda">Uganda</option>
                <option value="Tanzania">Tanzania</option>
                <option value="Rwanda">Rwanda</option>
            </select>-->
        </label>

        <label for="password">Password
            <div class="password-input">
                <input type="password" id="password" name="password" required>
                <span class="password-toggle" onclick="togglePassword()">👁</span>
            </div>
        </label>

        <label for="terms" style="text-align: left;">
            <input type="checkbox" id="terms" name="terms" value="1" required>
            I have read and agree to the <a href="#privacyPolicyModal" data-toggle="modal">Privacy Policy</a> and <a
                href="#termsConditionsModal" data-toggle="modal">Terms and Conditions</a>
        </label>

        <button type="submit" class="primary" style="width: 100%;">Register</button>
    </form>

    <style>
        .password-input {
            position: relative;
            display: flex;
            align-items: center;
        }

        .password-input input[type="password"],
        .password-input input[type="text"] {
            padding-right: 30px;
            /* Space for the eye icon */
            width: 100%;
        }

        .password-toggle {
            position: absolute;
            right: 5px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            user-select: none;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }

        .modal-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            max-width: 80%;
            max-height: 80%;
            overflow: auto;
        }

        .close {
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 20px;
            cursor: pointer;
        }
    </style>

    <!-- Modals -->
    <div id="privacyPolicyModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal('privacyPolicyModal')">&times;</span>
            <?php include 'privacy_policy.php'; ?>
        </div>
    </div>

    <div id="termsConditionsModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal('termsConditionsModal')">&times;</span>
            <?php include 'terms_and_conditions.php'; ?>
        </div>
    </div>

    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
        }

        // Modal Functions
        function openModal(modalId) {
            document.getElementById(modalId).style.display = "block";
        }

        function closeModal(modalId) {
            document.getElementById(modalId).style.display = "none";
        }

        // Event listeners for modal links
        document.querySelector('a[href="#privacyPolicyModal"]').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default link behavior
            openModal('privacyPolicyModal');
        });

        document.querySelector('a[href="#termsConditionsModal"]').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default link behavior
            openModal('termsConditionsModal');
        });

        // Close modal if clicked outside the content
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = "none";
            }
        }
    </script>
</article>
