<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        if (empty($_POST['name'])) throw new Exception("School Name is required.");
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) throw new Exception("Invalid email address.");
        if (!preg_match('/^2547[0-9]{8}$/', $_POST['phone_number'])) throw new Exception("Invalid phone number format (expecting 2547xxxxxxxx).");
        if (empty($_POST['county'])) throw new Exception("County is required.");
        if (empty($_POST['country'])) throw new Exception("Country is required.");
        if (strlen($_POST['password']) < 8) throw new Exception("Password must be at least 8 characters.");
        if ($_POST['password'] !== $_POST['confirm_password']) throw new Exception("Passwords do not match.");

        $school = R::dispense('school');
        $school->name = htmlspecialchars($_POST['name']);
        $school->email = $_POST['email'];
        $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
        $school->address = htmlspecialchars($_POST['county']);
        $school->country = htmlspecialchars($_POST['country']);
        $school->status = 'inactive';
        $school->subscription_expiry = null;

        $school_id = R::store($school);
        $school_name = $school->name;

        setcookie('school_id', $school_id, time() + 86400, "/");
        setcookie('school_name', $school_name, time() + 86400, "/");

        echo "<p>Registration successful!</p>";
        echo "<p>School: <strong>" . htmlspecialchars($school_name) . "</strong> | ID: <strong>" . htmlspecialchars($school_id) . "</strong></p>";
        echo "<p>Redirecting to dashboard...</p>";
        echo '<script>setTimeout(() => { window.location.href = "./index.php?action=school_dashboard"; }, 5000);</script>';
        exit;
    } catch (Exception $e) {
        echo "<p>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        echo "<p><a href='?action=school_register'>Try Again</a></p>";
        exit;
    }
}
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@2/css/pico.cyan.min.css">
<style>
    html, body {
        padding: 0;
        margin: 0;
        background: #f8faff;
    }
    .card {
        max-width: 550px;
        margin: 0 auto;
        background: white;
        padding: 2rem;
        border-radius: 1rem;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }
    .password-toggle {
        position: relative;
    }
    .toggle-icon {
        position: absolute;
        right: 1rem;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 1.2rem;
    }
    td {
        padding: 0.5rem;
    }
    input, select {
        width: 100%;
    }
</style>

<div class="card">
    <h2 style="text-align:center;">School Registration</h2>
    <form method="POST">
        <table style="width: 100%;">
            <tr>
                <td><label for="name">School Name</label></td>
                <td><input type="text" id="name" name="name" required></td>
            </tr>
            <tr>
                <td><label for="email">Email</label></td>
                <td><input type="email" id="email" name="email" required></td>
            </tr>
            <tr>
                <td><label for="phone_number">Phone Number</label></td>
                <td><input type="tel" id="phone_number" name="phone_number" pattern="2547[0-9]{8}" placeholder="2547xxxxxxxx" required></td>
            </tr>
            <tr>
                <td><label for="county">County</label></td>
                <td><input type="text" id="county" name="county"></td>
            </tr>
            <tr>
                <td><label for="country">Country</label></td>
                <td>
                    <select id="country" name="country" required>
                        <option value="Kenya" selected>Kenya</option>
                        <option value="Uganda">Uganda</option>
                        <option value="Tanzania">Tanzania</option>
                        <option value="Rwanda">Rwanda</option>
                    </select>
                </td>
            </tr>
            <tr>
                <td><label for="password">Password</label></td>
                <td class="password-toggle">
                    <input type="password" id="password" name="password" required>
                    <span class="toggle-icon" onclick="togglePassword('password')">👁️</span>
                </td>
            </tr>
            <tr>
                <td><label for="confirm_password">Confirm Password</label></td>
                <td class="password-toggle">
                    <input type="password" id="confirm_password" name="confirm_password" required>
                    <span class="toggle-icon" onclick="togglePassword('confirm_password')">👁️</span>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="text-align:center;">
                    <button type="submit">Register</button>
                </td>
            </tr>
        </table>
    </form>
</div>

<script>
function togglePassword(id) {
    const input = document.getElementById(id);
    input.type = input.type === "password" ? "text" : "password";
}
</script>
