<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        if (empty($_POST['name'])) throw new Exception("School Name is required.");
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) throw new Exception("Invalid email address.");
        if (!preg_match('/^2547[0-9]{8}$/', $_POST['phone_number'])) throw new Exception("Invalid phone number format (expecting 2547xxxxxxxx).");
        if (empty($_POST['county'])) throw new Exception("County is required.");
        if (empty($_POST['country'])) throw new Exception("Country is required.");
        if (strlen($_POST['password']) < 8) throw new Exception("Password must be at least 8 characters.");
        if ($_POST['password'] !== $_POST['confirm_password']) throw new Exception("Passwords do not match.");

        // Check if email already exists
        $existing_school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if ($existing_school) {
            $message = '⚠️ This email is already registered. <a href="index.php?action=reset_school_password&email=' . htmlspecialchars($_POST['email']) . '">Reset password?</a>';
            $showForm = false; // Prevent registration
        } else {

            $school = R::dispense('school');
            $school->name = htmlspecialchars($_POST['name']);
            $school->email = $_POST['email'];
            $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
            $school->address = htmlspecialchars($_POST['county']);
            $school->country = htmlspecialchars($_POST['country']);
            $school->status = 'inactive';
            $school->subscription_expiry = null;

            $school_id = R::store($school);
            $school_name = $school->name;

            setcookie('school_id', $school_id, time() + 86400, "/");
            setcookie('school_name', $school_name, time() + 86400, "/");

            echo "<p>Registration successful!</p>";
            echo "<p>School: <strong>" . htmlspecialchars($school_name) . "</strong> | ID: <strong>" . htmlspecialchars($school_id) . "</strong></p>";
            echo "<p>Redirecting to dashboard...</p>";
            echo '<script>setTimeout(() => { window.location.href = "./index.php?action=school_dashboard"; }, 5000);</script>';
            exit;
        }
    } catch (Exception $e) {
        echo "<p>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        echo "<p><a href='?action=school_register'>Try Again</a></p>";
        exit;
    }
}
?>

<article class="card" style="max-width: 80%; margin: 2rem auto;">
    <header>
        <h2 style="text-align: center;">School Registration</h2>
    </header>

    <form method="POST" style="padding: 1rem;">
        <label for="name">School Name
            <input type="text" id="name" name="name" required>
        </label>

        <label for="email">Email
            <input type="email" id="email" name="email" required>
        </label>

        <label for="phone_number">Phone Number
            <input type="tel" id="phone_number" name="phone_number" pattern="2547[0-9]{8}"
                placeholder="2547xxxxxxxx" required>
        </label>

        <label for="county">County
            <input type="text" id="county" name="county" required>
        </label>

        <label for="country">Country
            <select id="country" name="country" required>
                <option value="Kenya" selected>Kenya</option>
                <option value="Uganda">Uganda</option>
                <option value="Tanzania">Tanzania</option>
                <option value="Rwanda">Rwanda</option>
            </select>
        </label>

        <label for="password">Password
            <input type="password" id="password" name="password" required>
        </label>

        <label for="confirm_password">Confirm Password
            <input type="password" id="confirm_password" name="confirm_password" required>
        </label>

        <button type="submit" class="primary" style="width: 100%;">Register</button>
    </form>
</article>
