<?php
// views/subscription_callback.php
session_start();

// Check for necessary GET parameters to prevent direct access
if (!isset($_GET['api_ref']) || !isset($_GET['status'])) {
    header('Location: index.php?action=school_login'); // Redirect to login if accessed directly
    exit();
}

$api_ref = $_GET['api_ref'];
$payment_status = $_GET['status'];

// Extract school ID from the api_ref (assuming format "MwalimuLink_School_Subscription_123")
$parts = explode("_", $api_ref);
$school_id = end($parts);  // Get the last part which should be the school ID

// Validate the school_id is numeric
if (!is_numeric($school_id)) {
    echo "<div class='w3-container w3-red'><h2>Error</h2><p>Invalid School ID in callback.</p></div>";
    exit();
}

$school = R::load('school', $school_id);

if (!$school->id) {
    echo "<div class='w3-container w3-red'><h2>Error</h2><p>School not found.</p></div>";
    exit();
}

// Check payment status
if ($payment_status === 'SUCCESS') {
    // Payment successful - activate the account and set expiry date
    $school->status = 'active';

    // Calculate expiry date (12 months from now)
    $expiry_date = new DateTime();
    $expiry_date->add(new DateInterval('P12M'));  // Adds 12 months
    $school->subscription_expiry = $expiry_date->format('Y-m-d H:i:s'); // Format for DATETIME

    R::store($school);

    echo "<div class='w3-container w3-green'><h2>Payment Successful!</h2>";
    echo "<p>Your school account is now active and will expire on " . htmlspecialchars($expiry_date->format('Y-m-d')) . ".</p>";
    echo "<p><a href='index.php?action=school_dashboard'>Go to Dashboard</a></p></div>";

    // Clear the new_school_id session variable (if it exists)
    unset($_COOKIE['new_school_id']);

    // Set school_id in session in case it's not already
    $_COOKIE['school_id'] = $school->id;

} else {
    // Payment failed - display an error message
    echo "<div class='w3-container w3-red'><h2>Payment Failed</h2>";
    echo "<p>Your payment was not successful. Please contact support or try again.</p></div>";
    echo "<p><a href='index.php?action=pay_subscription'>Try Again</a></p></div>";
}
?>
