<?php
// Check if the teacher is logged in via cookies
if (!isset($_COOKIE['teacher_id']) || !isset($_COOKIE['teacher_name'])) {
    header('Location: index.php?action=teacher_login');
    exit();
}

// Retrieve teacher details from cookies
$teacher_id = htmlspecialchars($_COOKIE['teacher_id']);
$teacher_name = htmlspecialchars($_COOKIE['teacher_name']);
?>

<div class="w3-container w3-green">
    <h2>Teacher Dashboard</h2>
</div>

<div class="w3-container">
    <h3>Welcome, <?php echo $teacher_name; ?>!</h3>
    <p>This is your dashboard. You can manage your profile, view job postings, etc., here.</p>

    <!-- Display Teacher Information -->
    <h4>Your Information</h4>
    <p>Teacher ID: <?php echo $teacher_id; ?></p>
    <p>Name: <?php echo $teacher_name; ?></p>

    <!-- Links -->
    <a href="?action=teacher_job_search" class="w3-button w3-blue">Search Job Postings</a><br><br>
    <a href="?action=teacher_update&teacher_id=<?php echo urlencode($teacher_id); ?>" class="w3-button w3-green">Update My Profile</a><br><br>
    <a href="index.php?action=logout" class="w3-button w3-red">Logout</a>
</div>

<?php
// Handle logout functionality
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    // Clear cookies by setting them with an expiration time in the past
    setcookie('teacher_id', '', time() - 3600, '/');
    setcookie('teacher_name', '', time() - 3600, '/');

    // Redirect to the landing page
    header('Location: index.php?action=landing');
    exit();
}
?>
