<?php
//if (!isset($_COOKIE['teacher_id'])) {
if (!isset($_COOKIE['teacher_id']) || !isset($_COOKIE['teacher_name'])) {
    header('Location: index.php?action=teacher_login');
    exit();
}

$teacher_id = $_COOKIE['teacher_id'];

// Fetch all job postings
$jobs = R::findAll('job');
?>

<div class="w3-container w3-green">
    <h2>Job Search</h2>
</div>

<div class="w3-container">
    <h3>Available Job Postings:</h3>

    <?php if (empty($jobs)): ?>
        <p>No job postings found.</p>
    <?php else: ?>
        <ul class="w3-ul">
            <?php foreach ($jobs as $job): ?>
                <li>
                    <strong><?php echo htmlspecialchars($job->title); ?></strong> -
                    <?php
                    $school = R::load('school', $job->school_id);
                    echo htmlspecialchars($school->name);
                    ?>
                    <br>
                    <?php echo htmlspecialchars(substr($job->description, 0, 100)); ?>...
                    <a href="index.php?action=teacher_job_apply&job_id=<?php echo $job->id; ?>" class="w3-button w3-green w3-small">Apply Now</a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>

    <a href="index.php?action=teacher_dashboard" class="w3-button w3-blue">Back to Dashboard</a>
</div>
