<?php
// Check if the teacher is logged in via cookies
if (!isset($_COOKIE['teacher_id']) || !isset($_COOKIE['teacher_name'])) {
    header('Location: index.php?action=teacher_login');
    exit();
}

// Retrieve teacher details from cookies
$teacher_id = htmlspecialchars($_COOKIE['teacher_id']);

// Fetch all job postings
$jobs = R::findAll('job');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Search</title>
    <link rel="stylesheet" href="https://unpkg.com/@picocss/pico@latest/css/pico.min.css">
</head>
<body>
    <header class="container">
        <h1>Job Search</h1>
        <p>Welcome to the job search page. Browse available job postings below.</p>
    </header>

    <main class="container">
        <h2>Available Job Postings</h2>

        <?php if (empty($jobs)): ?>
            <article>
                <p>No job postings found.</p>
            </article>
        <?php else: ?>
            <div class="grid">
                <?php foreach ($jobs as $job): ?>
                    <!-- Card Layout for Job Posting -->
                    <article class="card">
                        <header>
                            <h3><?php echo htmlspecialchars($job->title); ?></h3>
                            <?php
                            $school = R::load('school', $job->school_id);
                            ?>
                            <p><strong>School:</strong> <?php echo htmlspecialchars($school->name); ?></p>
                        </header>

                        <p><?php echo htmlspecialchars(substr($job->description, 0, 100)); ?>...</p>

                        <!-- Apply Now Button -->
                        <footer>
                            <a href="index.php?action=teacher_job_apply&job_id=<?php echo $job->id; ?>" class="button primary">Apply Now</a>
                        </footer>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <!-- Back to Dashboard Button -->
        <a href="index.php?action=teacher_dashboard" class="button secondary">Back to Dashboard</a>
    </main>
</body>
</html>
