<?php
// Check if the form is submitted via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize user input to prevent SQL injection or XSS attacks
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $password = $_POST['password'];

    // Find the teacher by email in the database using RedBeanPHP
    $teacher = R::findOne('teacher', 'email = ?', [$email]);

    // Verify password and handle login logic
    if ($teacher && password_verify($password, $teacher->password)) {
        // Set cookies for logged-in teacher (valid for 1 day)
        setcookie('teacher_id', $teacher->id, time() + 86400, '/', '', false, true); // httponly flag for security
        setcookie('teacher_name', $teacher->name, time() + 86400, '/', '', false, true);

        // Redirect to the teacher dashboard
        header('Location: index.php?action=teacher_dashboard');
        exit();
    } else {
        $error_message = "Invalid email or password.";
    }
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Teacher Login</h2>
    </header>

    <?php if (isset($error_message)): ?>
        <div class="alert alert-error">
            <h4><?php echo htmlspecialchars($error_message); ?></h4>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="grid">
            <input type="email" id="email" placeholder="Email" name="email" required>
        </div>

        <div class="grid">
            <input type="password" placeholder="Password" id="password" name="password" required>
        </div>

        <button type="submit">Login</button>
    </form>
    <p>Don't have a Teacher account? <a href="index.php?action=teacher_register">Create one for free here.</a></p>
</article>
<p>&nbsp;</p>
<!--
<div class="w3-container w3-green">
    <h2>Teacher Login</h2>
</div>

<?php if (isset($error_message)): ?>
<div class="w3-container w3-red">
    <h4><?php echo htmlspecialchars($error_message); ?></h4>
</div>
<?php endif; ?>

<form method="POST" action="" class="w3-container">
    <label>Email:</label>
    <input type="email" name="email" required class="w3-input"><br>
    <label>Password:</label>
    <input type="password" name="password" required class="w3-input"><br>
    <button type="submit" class="w3-button w3-blue">Login</button>
</form>-->
