<?php
// Get teacher ID from query parameter
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch teacher details from the database
$teacher = R::load('teacher', $id);

if (!$teacher->id) {
    echo "<div class='w3-container w3-red'><h3>Teacher not found.</h3></div>";
    exit();
}
?>

<div class="w3-container w3-green">
    <h2>Teacher Profile: <?php echo htmlspecialchars($teacher->name); ?></h2>
</div>

<div class="w3-container">
    <h3>Details:</h3>
    <p><strong>Name:</strong> <?php echo htmlspecialchars($teacher->name); ?></p>
    <p><strong>Email:</strong> <a href="mailto:<?php echo htmlspecialchars($teacher->email); ?>"><?php echo htmlspecialchars($teacher->email); ?></a></p>
    <p><strong>Phone Number:</strong> <?php echo htmlspecialchars($teacher->phone_number); ?></p>
    <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($teacher->date_of_birth); ?></p>
    <p><strong>Teaching Subjects:</strong> <?php echo htmlspecialchars($teacher->teaching_subjects); ?></p>
    <p><strong>Grade Levels:</strong> <?php echo htmlspecialchars($teacher->grade_levels); ?></p>
    <p><strong>Years of Experience:</strong> <?php echo htmlspecialchars($teacher->years_of_experience); ?> years</p>
    <p><strong>Degrees Obtained:</strong> <?php echo htmlspecialchars($teacher->degrees_obtained); ?></p>
    <p><strong>Institutions Attended:</strong> <?php echo htmlspecialchars($teacher->institutions_attended); ?></p>
    <p><strong>Graduation Dates:</strong> <?php echo htmlspecialchars($teacher->graduation_dates); ?></p>
    <p><strong>TSC Number:</strong> <?php echo htmlspecialchars($teacher->tsc_number); ?></p>
    <p><strong>County:</strong> <?php echo htmlspecialchars($teacher->county); ?></p>
    <p><strong>Country:</strong> <?php echo htmlspecialchars($teacher->country); ?></p>

    <h3>Downloads:</h3>
    <ul class="w3-ul">
        <li><a href="<?php echo htmlspecialchars($teacher->resume); ?>" download class="w3-button w3-blue">Download Resume</a></li>
        <!-- Add certificate download links if available -->
        <!-- Example: -->
        <!-- <li><a href="<?php echo htmlspecialchars($teacher->certificates); ?>" download class="w3-button w3-blue">Download Certificates</a></li>-->
    </ul>

    <h3>Contact Teacher:</h3>
    <a href="mailto:<?php echo htmlspecialchars($teacher->email); ?>" class="w3-button w3-green">Email Teacher</a>
</div>

