<?php
// Check if the teacher ID is provided in the query parameters
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Load the teacher from the database
$teacher = R::load('teacher', $id);

// If the teacher is not found, display an error message and exit
if (!$teacher->id) {
    echo '<main class="container"><article><div class="message -error">Teacher not found.</div></article></main>';
    exit();
}
?>

<main class="container">
    <article>
        <h3>Teacher Profile: <?php echo htmlspecialchars($teacher->name); ?></h3>

        <p><strong>Name:</strong> <?php echo htmlspecialchars($teacher->name); ?></p>
        <p><strong>Email:</strong> <a
                href="mailto:<?php echo htmlspecialchars($teacher->email); ?>"><?php echo htmlspecialchars($teacher->email); ?></a>
        </p>
        <p><strong>Gender:</strong> <?php echo htmlspecialchars($teacher->gender); ?></p>
        <p><strong>Age:</strong> <?php echo htmlspecialchars($teacher->age); ?></p>
        <p><strong>Mobile:</strong> <?php echo htmlspecialchars($teacher->mobile); ?></p>
        <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($teacher->date_of_birth); ?></p>
        <p><strong>Grade Level:</strong> <?php echo htmlspecialchars($teacher->grade_level); ?></p>
        <p><strong>Teaching Subject:</strong> <?php echo htmlspecialchars($teacher->teaching_subject); ?></p>
        <p><strong>Institution Attended:</strong> <?php echo htmlspecialchars($teacher->institutions_attended); ?></p>
        <p><strong>Years of Experience:</strong> <?php echo htmlspecialchars($teacher->years_of_experience); ?>
            years</p>
        <p><strong>Qualification:</strong> <?php echo htmlspecialchars($teacher->qualification); ?></p>
        <p><strong>County:</strong> <?php echo htmlspecialchars($teacher->county); ?></p>
        <p><strong>Country:</strong> <?php echo htmlspecialchars($teacher->country); ?></p>
        <p><strong>TSC Number:</strong> <?php echo htmlspecialchars($teacher->tsc_number); ?></p>
        <p><strong>Brief Profile:</strong> <?php echo htmlspecialchars($teacher->brief_profile); ?></p>

        <a href="mailto:<?php echo htmlspecialchars($teacher->email); ?>" role="button">Email Teacher</a>
    </article>
</main>
