<?php
/**
// Check if the teacher is logged in
if (!isset($_COOKIE['teacher_id'])) {
    header("Location: index.php?action=teacher_login");
    exit();
}
**/

// Check if the teacher is logged in or if school_id or id is set
if (!isset($_COOKIE['teacher_id']) && !isset($_COOKIE['school_id']) && !isset($_GET['id'])) {
    header("Location: index.php?action=teacher_login");
    exit();
}

// Get the teacher's ID from the cookie or GET parameter
$teacher_id = $_COOKIE['teacher_id'] ?? $_GET['id'] ?? null;

// If teacher_id is null, handle the error
if ($teacher_id === null) {
    echo "<div class='container'><article class='message -error'>Teacher ID not found.</article></div>";
    exit();
}

// Fetch the teacher's data from the database
$teacher = R::load('teacher', $teacher_id);

// If the teacher doesn't exist, handle the error
if (!$teacher->id) {
    echo "<div class='container'><article class='message -error'>Teacher not found.</article></div>";
    exit();
}
// Get the teacher's ID from the cookie
//KESH REMOVED THIS BECAUSE IT IS SET UP TOP$teacher_id = $_COOKIE['teacher_id'];

// Fetch the teacher's data from the database
$teacher = R::load('teacher', $teacher_id);

// If the teacher doesn't exist, handle the error
if (!$teacher->id) {
    echo "<div class='container'><article class='message -error'>Teacher not found.</article></div>";
    exit();
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Teacher Profile: <?php echo htmlspecialchars($teacher->name ?? ''); ?></h2>
    </header>

    <div style="padding: 1rem;">
        <h3>Personal Details</h3>
        <p><strong>Name:</strong> <?php echo htmlspecialchars($teacher->name ?? ''); ?></p>
        <p><strong>Email:</strong> <a href="mailto:<?php echo htmlspecialchars($teacher->email ?? ''); ?>"><?php echo htmlspecialchars($teacher->email ?? ''); ?></a></p>
        <p><strong>Gender:</strong> <?php echo htmlspecialchars($teacher->gender ?? ''); ?></p>
        <p><strong>Age:</strong> <?php echo htmlspecialchars($teacher->age ?? ''); ?></p>
        <p><strong>Mobile:</strong> <?php echo htmlspecialchars($teacher->mobile ?? ''); ?></p>
        <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($teacher->date_of_birth ?? ''); ?></p>

        <h3>Professional Details</h3>
        <p><strong>Grade Level:</strong> <?php echo htmlspecialchars($teacher->grade_level ?? ''); ?></p>
        <p><strong>Teaching Subject:</strong> <?php echo htmlspecialchars($teacher->teaching_subject ?? ''); ?></p>
        <p><strong>Institution Attended:</strong> <?php echo htmlspecialchars($teacher->institutions_attended ?? ''); ?></p>
        <p><strong>Years of Experience:</strong> <?php echo htmlspecialchars($teacher->years_of_experience ?? ''); ?> years</p>
        <p><strong>Qualification:</strong> <?php echo htmlspecialchars($teacher->qualification ?? ''); ?></p>

        <h3>Location & Credentials</h3>
        <p><strong>County:</strong> <?php echo htmlspecialchars($teacher->county ?? ''); ?></p>
        <p><strong>Country:</strong> <?php echo htmlspecialchars($teacher->country ?? ''); ?></p>
        <p><strong>TSC Number:</strong> <?php echo htmlspecialchars($teacher->tsc_number ?? ''); ?></p>

        <h3>Brief Profile</h3>
        <p><?php echo htmlspecialchars($teacher->brief_profile ?? ''); ?></p>

        <button type="button" onclick="location.href='mailto:<?php echo htmlspecialchars($teacher->email ?? ''); ?>'" style="width: 10rem; height: 3rem; display: flex; justify-content: center; align-items: center; background-color: #f7f7f2; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-envelope fa-lg"></i>
            <span>Email Teacher</span>
        </button>
    </div>
</article>
