<?php
// Check if the teacher ID is provided in the query parameters
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Load the teacher from the database
$teacher = R::load('teacher', $id);

// If the teacher is not found, display an error message and exit
if (!$teacher->id) {
    echo '<article class="alert error">Teacher not found.</article>';
    exit();
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Teacher Profile: <?php echo htmlspecialchars($teacher->name); ?></h2>
    </header>

    <form style="padding: 1rem;">
        <label for="name">Full Name</label>
        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($teacher->name); ?>" readonly>

        <label for="email">Email</label>
        <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($teacher->email); ?>" readonly>

        <label for="gender">Gender</label>
        <input type="text" id="gender" name="gender" value="<?php echo htmlspecialchars($teacher->gender); ?>" readonly>

        <label for="age">Age</label>
        <input type="number" id="age" name="age" value="<?php echo htmlspecialchars($teacher->age); ?>" readonly>

        <label for="mobile">Mobile</label>
        <input type="tel" id="mobile" name="mobile" value="<?php echo htmlspecialchars($teacher->mobile); ?>" readonly>

        <label for="dob">Date of Birth</label>
        <input type="date" id="dob" name="dob" value="<?php echo htmlspecialchars($teacher->date_of_birth); ?>" readonly>

        <label for="grade_level">Grade Level</label>
        <input type="text" id="grade_level" name="grade_level" value="<?php echo htmlspecialchars($teacher->grade_level); ?>" readonly>

        <label for="teaching_subject">Teaching Subject</label>
        <input type="text" id="teaching_subject" name="teaching_subject" value="<?php echo htmlspecialchars($teacher->teaching_subject); ?>" readonly>

        <label for="institutions_attended">Institution Attended</label>
        <input type="text" id="institutions_attended" name="institutions_attended" value="<?php echo htmlspecialchars($teacher->institutions_attended); ?>" readonly>

        <label for="years_of_experience">Years of Experience</label>
        <input type="number" id="years_of_experience" name="years_of_experience" value="<?php echo htmlspecialchars($teacher->years_of_experience); ?>" readonly>

        <label for="qualification">Qualification</label>
        <input type="text" id="qualification" name="qualification" value="<?php echo htmlspecialchars($teacher->qualification); ?>" readonly>

        <label for="county">County</label>
        <input type="text" id="county" name="county" value="<?php echo htmlspecialchars($teacher->county); ?>" readonly>

        <label for="country">Country</label>
        <input type="text" id="country" name="country" value="<?php echo htmlspecialchars($teacher->country); ?>" readonly>

        <label for="tsc_number">TSC Number</label>
        <input type="text" id="tsc_number" name="tsc_number" value="<?php echo htmlspecialchars($teacher->tsc_number); ?>" readonly>

        <label for="brief_profile">Brief Profile</label>
        <textarea id="brief_profile" name="brief_profile" rows=5 readonly><?php echo htmlspecialchars($teacher->brief_profile); ?></textarea>

        <!-- Email Button -->
        <button onclick="location.href='mailto:<?php echo htmlspecialchars($teacher->email); ?>'" class="secondary">
            Email Teacher
        </button>
    </form>
</article>
