<?php
$message = '';
$showForm = true;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $teacher = R::dispense('teacher');

    $teacher->name = $_POST['name'] ?? '';
    $teacher->email = $_POST['email'] ?? '';
    $teacher->password = password_hash($_POST['password'] ?? '', PASSWORD_DEFAULT);
    $teacher->date_of_birth = $_POST['date_of_birth'] ?? '';
    $teacher->gender = $_POST['gender'] ?? '';
    $teacher->age = $_POST['age'] ?? '';
    $teacher->mobile = $_POST['mobile'] ?? '';
    $teacher->years_of_experience = $_POST['years_of_experience'] ?? '';
    $teacher->grade_level = $_POST['grade_level'] ?? '';
    $teacher->teaching_subject = $_POST['teaching_subject'] ?? '';
    $teacher->qualification = $_POST['qualification'] ?? '';
    $teacher->institutions_attended = $_POST['institutions_attended'] ?? '';
    $teacher->county = $_POST['county'] ?? '';
    $teacher->country = $_POST['country'] ?? '';
    $teacher->tsc_number = $_POST['tsc_number'] ?? '';
    $teacher->brief_profile = $_POST['brief_profile'] ?? '';
    $teacher->created_at = date('Y-m-d H:i:s');

    R::store($teacher);
    $message = '🎉 Registration successful!';
    $showForm = false;
}
?>

<h2>Register as a Teacher</h2>

<?php if ($message): ?>
  <article class="success"><?= htmlspecialchars($message) ?></article>
<?php endif; ?>

<?php if ($showForm): ?>
<form method="post" id="registrationForm">
  <label>
    Full Name
    <input type="text" name="name" required>
  </label>

  <label>
    Email
    <input type="email" name="email" required>
  </label>

  <label>
    Password
    <input type="password" name="password" id="password" required>
    <small><a href="#" onclick="togglePassword(event)">👁 Show Password</a></small>
  </label>

  <label>
    Date of Birth
    <input type="date" name="date_of_birth" required>
  </label>

  <label>
    Gender
    <select name="gender" required>
      <option value="">-- Select --</option>
      <option>Male</option>
      <option>Female</option>
      <option>Other</option>
    </select>
  </label>

  <label>
    Age
    <input type="number" name="age" required>
  </label>

  <label>
    Mobile
    <input type="tel" name="mobile" required>
  </label>

  <label>
    Years of Experience
    <input type="number" name="years_of_experience" required>
  </label>

  <label>
    Grade Level
    <input type="text" name="grade_level" required>
  </label>

  <label>
    Teaching Subject
    <input type="text" name="teaching_subject" required>
  </label>

  <label>
    Qualification
    <select name="qualification" required>
      <option value="">-- Select --</option>
      <option>Diploma</option>
      <option>Bachelor's Degree</option>
      <option>Postgraduate Diploma</option>
      <option>Masters</option>
      <option>PhD</option>
      <option>Other</option>
    </select>
  </label>

 <label>
    Institution Attended
    <input type="text" name="institutions_attended" required>
  </label>

  <label>
    County
    <input type="text" name="county" required>
  </label>

  <label>
    Country
    <select name="country" required>
      <option value="Kenya" selected>Kenya</option>
      <option value="Uganda">Uganda</option>
      <option value="Tanzania">Tanzania</option>
      <option value="Rwanda">Rwanda</option>
      <option value="Burundi">Burundi</option>
      <option value="South Sudan">South Sudan</option>
    </select>
  </label>

  <label>
    TSC Number
    <input type="text" name="tsc_number" required>
  </label>

  <label>
    Brief Profile (max 100 words)
    <textarea name="brief_profile" maxlength="1000" rows="5" required></textarea>
  </label>

  <button type="submit">Register</button>
</form>
<?php endif; ?>

<script>
  function togglePassword(e) {
    e.preventDefault();
    const passwordInput = document.getElementById('password');
    const type = passwordInput.getAttribute('type');
    passwordInput.setAttribute('type', type === 'password' ? 'text' : 'password');
    e.target.textContent = type === 'password' ? '🙈 Hide Password' : '👁 Show Password';
  }
</script>
