<?php
session_start(); // Start the session

// Check if the teacher is logged in
if (!isset($_COOKIE['teacher_id'])) {
    header("Location: index.php?action=teacher_login"); // Redirect to login page if not logged in
    exit();
}

// Get the teacher's ID from the session
$teacher_id = $_SESSION['teacher_id'];

// Fetch the teacher's data from the database
$teacher = R::load('teacher', $teacher_id);

// If the teacher doesn't exist, handle the error
if (!$teacher->id) {
    echo "<div class='w3-container w3-red'><h2>Error!</h2><p>Teacher not found.</p></div>";
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and update the teacher's information
    $teacher->name = $_POST['name'];
    $teacher->date_of_birth = $_POST['date_of_birth'];
    $teacher->email = $_POST['email'];
    $teacher->phone_number = $_POST['phone_number'];
    $teacher->teaching_subjects = $_POST['teaching_subjects'];
    $teacher->grade_levels = $_POST['grade_levels'];
    $teacher->years_of_experience = $_POST['years_of_experience'];
	$teacher->county = $_POST['county'];
    $teacher->country = $_POST['country'];

    // Handle password update (only if a new password is provided)
    if (!empty($_POST['password'])) {
        $teacher->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    }

    // Handle educational background updates
    if (isset($_POST['degrees_obtained']) && !empty($_POST['degrees_obtained'])) {
        $teacher->degrees_obtained = $_POST['degrees_obtained'];
        $teacher->institutions_attended = $_POST['institutions_attended'];
        $teacher->graduation_dates = $_POST['graduation_dates'];
        $teacher->diploma = null;
        $teacher->diploma_institution = null;
        $teacher->diploma_completion_date = null;
    } else {
        $teacher->degrees_obtained = null;
        $teacher->institutions_attended = null;
        $teacher->graduation_dates = null;
        $teacher->diploma = $_POST['diploma'];
        $teacher->diploma_institution = $_POST['diploma_institution'];
        $teacher->diploma_completion_date = $_POST['diploma_completion_date'];
    }

    $teacher->teaching_certifications = $_POST['teaching_certifications'];
    $teacher->tsc_number = $_POST['tsc_number'];

    // Handle resume update
    if ($_FILES['resume']['error'] === UPLOAD_ERR_OK) {
        $resume = $_FILES['resume'];
        $resume_name = $resume['name'];
        $resume_tmp_name = $resume['tmp_name'];
        $upload_dir = 'uploads/';

        // Ensure the upload directory exists
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        $resume_path = $upload_dir . basename($resume_name);

        if (move_uploaded_file($resume_tmp_name, $resume_path)) {
            // Update the resume path
            $teacher->resume = $resume_path;
        } else {
            echo "<div class='w3-container w3-red'><h2>Update Failed!</h2>";
            echo "<p>There was an error uploading your resume. Please try again.</p></div>";
        }
    }

    // Save the updated teacher data
    R::store($teacher);

    echo "<div class='w3-container w3-green'><h2>Update Successful!</h2>";
    echo "<p>Your profile has been updated.</p></div>";
}
?>

<div class="w3-container w3-green">
    <h2>Update Teacher Profile</h2>
</div>

<style>
    .step-form {
        background-color: #ffffff;
        margin: 20px auto;
        font-family: "Open Sans", Arial, sans-serif;
        padding: 20px;
        width: 70%;
        min-width: 300px;
        box-sizing: border-box;
    }

    input {
        padding: 10px;
        width: 100%;
        font-size: 17px;
        font-family: "Open Sans", Arial, sans-serif;
        border: 1px solid #aaaaaa;
        box-sizing: border-box;
    }

    input.invalid {
        background-color: #ffdddd;
    }

    .tab {
        display: none;
    }

    button {
        background-color: #04AA6D;
        color: #ffffff;
        border: none;
        padding: 10px 20px;
        font-size: 17px;
        font-family: "Open Sans", Arial, sans-serif;
        cursor: pointer;
    }

    button:hover {
        opacity: 0.8;
    }

    #prevBtn {
        background-color: #bbbbbb;
    }

    .step {
        height: 15px;
        width: 15px;
        margin: 0 2px;
        background-color: #bbbbbb;
        border: none;
        border-radius: 50%;
        display: inline-block;
        opacity: 0.5;
    }

    .step.active {
        opacity: 1;
    }

    .step.finish {
        background-color: #04AA6D;
    }
</style>

<form id="updateForm" method="POST" action="" enctype="multipart/form-data" class="step-form">
    <!-- One "tab" for each step in the form: -->
    <div class="tab">
        <h4>Personal Information</h4>
        <p><input placeholder="Name..." oninput="this.className = ''" name="name" value="<?php echo htmlspecialchars($teacher->name); ?>" required></p>
        <p><input type="date" placeholder="Date of Birth..." oninput="this.className = ''" name="date_of_birth" value="<?php echo htmlspecialchars($teacher->date_of_birth); ?>" required></p>
        <p><input type="email" placeholder="Email..." oninput="this.className = ''" name="email" value="<?php echo htmlspecialchars($teacher->email); ?>" required></p>
        <p><input type="tel" placeholder="Phone Number..." oninput="this.className = ''" name="phone_number" value="<?php echo htmlspecialchars($teacher->phone_number); ?>" required></p>
        <p><input type="password" placeholder="New Password (leave blank to keep current)..." oninput="this.className = ''" name="password"></p>
		<p><input placeholder="County..." oninput="this.className = ''" name="county" value="<?php echo htmlspecialchars($teacher->county); ?>" required></p>
        <p><input placeholder="Country..." oninput="this.className = ''" name="country" value="<?php echo htmlspecialchars($teacher->country); ?>" required></p>
    </div>

    <div class="tab">
        <h4>Professional Details</h4>
        <p><input placeholder="Teaching Subjects..." oninput="this.className = ''" name="teaching_subjects" value="<?php echo htmlspecialchars($teacher->teaching_subjects); ?>" required></p>
        <p><input placeholder="Grade Levels..." oninput="this.className = ''" name="grade_levels" value="<?php echo htmlspecialchars($teacher->grade_levels); ?>" required></p>
        <p><input type="number" placeholder="Years of Experience..." oninput="this.className = ''" name="years_of_experience" value="<?php echo htmlspecialchars($teacher->years_of_experience); ?>" required></p>
    </div>

    <div class="tab">
        <h4>Educational Background</h4>
        <label>
            <input type="radio" name="has_degree" value="yes" <?php if ($teacher->degrees_obtained) echo 'checked'; ?>>
            Degree(s)
        </label>
        <label>
            <input type="radio" name="has_degree" value="no" <?php if ($teacher->diploma) echo 'checked'; ?>>
            Diploma
        </label><br><br>

        <div id="degree_fields" <?php if (!$teacher->degrees_obtained) echo 'style="display: none;"'; ?>>
            <p><input placeholder="Degree(s) Obtained..." oninput="this.className = ''" name="degrees_obtained" value="<?php echo htmlspecialchars($teacher->degrees_obtained); ?>"></p>
            <p><input placeholder="Institution(s) Attended..." oninput="this.className = ''" name="institutions_attended" value="<?php echo htmlspecialchars($teacher->institutions_attended); ?>"></p>
            <p><input type="date" placeholder="Graduation Date(s)..." oninput="this.className = ''" name="graduation_dates" value="<?php echo htmlspecialchars($teacher->graduation_dates); ?>"></p>
        </div>

        <div id="diploma_fields" <?php if (!$teacher->diploma) echo 'style="display: none;"'; ?>>
            <p><input placeholder="Diploma..." oninput="this.className = ''" name="diploma" value="<?php echo htmlspecialchars($teacher->diploma); ?>"></p>
            <p><input placeholder="Institution..." oninput="this.className = ''" name="diploma_institution" value="<?php echo htmlspecialchars($teacher->diploma_institution); ?>"></p>
            <p><input type="date" placeholder="Completion Date..." oninput="this.className = ''" name="diploma_completion_date" value="<?php echo htmlspecialchars($teacher->diploma_completion_date); ?>"></p>
        </div>
    </div>

    <div class="tab">
        <h4>Certifications and Resume</h4>
        <p><input placeholder="Teaching Certification(s)..." oninput="this.className = ''" name="teaching_certifications" value="<?php echo htmlspecialchars($teacher->teaching_certifications); ?>" required></p>
        <p><input placeholder="TSC Number (if applicable)..." oninput="this.className = ''" name="tsc_number" value="<?php echo htmlspecialchars($teacher->tsc_number); ?>"></p>
        <label>Upload Your Resume:</label>
        <input type="file" name="resume">
    </div>

    <div style="overflow:auto;">
        <div style="float:right;">
            <button type="button" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
            <button type="button" id="nextBtn" onclick="nextPrev(1)">Next</button>
        </div>
    </div>

    <div style="text-align:center;margin-top:40px;">
        <span class="step"></span>
        <span class="step"></span>
        <span class="step"></span>
        <span class="step"></span>
    </div>
</form>

<script>
    var currentTab = 0;
    showTab(currentTab);

    function showTab(n) {
        var x = document.getElementsByClassName("tab");
        x[n].style.display = "block";

        if (n == 0) {
            document.getElementById("prevBtn").style.display = "none";
        } else {
            document.getElementById("prevBtn").style.display = "inline";
        }

        if (n == (x.length - 1)) {
            document.getElementById("nextBtn").innerHTML = "Update";
        } else {
            document.getElementById("nextBtn").innerHTML = "Next";
        }

        fixStepIndicator(n)
    }

    function nextPrev(n) {
        var x = document.getElementsByClassName("tab");
        if (n == 1 && !validateForm()) return false;
        x[currentTab].style.display = "none";
        currentTab = currentTab + n;
        if (currentTab >= x.length) {
            document.getElementById("updateForm").submit();
            return false;
        }
        showTab(currentTab);
    }

    function validateForm() {
        var x, y, i, valid = true;
        x = document.getElementsByClassName("tab");
        y = x[currentTab].getElementsByTagName("input");
        for (i = 0; i < y.length; i++) {
            if (y[i].hasAttribute("required") && y[i].value == "") {
                y[i].className += " invalid";
                valid = false;
            }
        }
        if (valid) {
            document.getElementsByClassName("step")[currentTab].className += " finish";
        }
        return valid;
    }

    function fixStepIndicator(n) {
        var i, x = document.getElementsByClassName("step");
        for (i = 0; i < x.length; i++) {
            x[i].className = x[i].className.replace(" active", "");
        }
        x[n].className += " active";
    }

    // JavaScript to toggle degree and diploma fields
    const degreeRadio = document.querySelector('input[name="has_degree"][value="yes"]');
    const diplomaRadio = document.querySelector('input[name="has_degree"][value="no"]');
    const degreeFields = document.getElementById('degree_fields');
    const diplomaFields = document.getElementById('diploma_fields');

    degreeRadio.addEventListener('change', () => {
        if (degreeRadio.checked) {
            degreeFields.style.display = 'block';
            diplomaFields.style.display = 'none';
        }
    });

    diplomaRadio.addEventListener('change', () => {
        if (diplomaRadio.checked) {
            degreeFields.style.display = 'none';
            diplomaFields.style.display = 'block';
        }
    });
</script>
