<?php
require_once 'rb.php';

$db_file = 'mwalimu.db';
R::setup("sqlite:$db_file");
R::freeze(false);

function h($str) { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }

$tables = R::inspect();

$table = $_GET['table'] ?? '';
$action = $_GET['action'] ?? 'list';
$page = max(1, intval($_GET['page'] ?? 1));
$per_page = 10;
$search = trim($_GET['search'] ?? '');

if ($table !== '' && !in_array($table, $tables)) {
    die('Invalid table.');
}

$message = '';

// POST handling (create, update, delete)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'create' && $table) {
        $bean = R::dispense($table);
        foreach ($_POST as $k => $v) {
            if ($k === 'id') continue;
            $bean[$k] = $v;
        }
        R::store($bean);
        $message = '<b style="color:green">Record created.</b>';
        $action = 'list';
    }
    if ($action === 'update' && $table && isset($_POST['id'])) {
        $bean = R::load($table, (int)$_POST['id']);
        foreach ($_POST as $k => $v) {
            if ($k === 'id') continue;
            $bean[$k] = $v;
        }
        R::store($bean);
        $message = '<b style="color:green">Record updated.</b>';
        $action = 'list';
    }
    if ($action === 'delete' && $table && isset($_POST['id'])) {
        $bean = R::load($table, (int)$_POST['id']);
        R::trash($bean);
        $message = '<b style="color:green">Record deleted.</b>';
        $action = 'list';
    }
}

// Helper: Pagination links
function paginate($total, $per_page, $page, $base_url) {
    $pages = max(1, ceil($total / $per_page));
    $page = max(1, min($page, $pages));
    echo '<nav aria-label="Pagination" style="margin-top:1rem;">';
    echo '<ul style="list-style:none; display:flex; gap:0.5rem; padding:0;">';
    echo $page > 1
        ? '<li><a href="' . h($base_url) . '&page=1">First</a></li>'
        : '<li style="color:#999; padding:0.3rem 0.6rem;">First</li>';
    echo $page > 1
        ? '<li><a href="' . h($base_url) . '&page=' . ($page - 1) . '">Prev</a></li>'
        : '<li style="color:#999; padding:0.3rem 0.6rem;">Prev</li>';
    echo '<li style="padding:0.3rem 0.6rem;">Page ' . $page . ' of ' . $pages . ' (Total: ' . $total . ')</li>';
    echo $page < $pages
        ? '<li><a href="' . h($base_url) . '&page=' . ($page + 1) . '">Next</a></li>'
        : '<li style="color:#999; padding:0.3rem 0.6rem;">Next</li>';
    echo $page < $pages
        ? '<li><a href="' . h($base_url) . '&page=' . $pages . '">Last</a></li>'
        : '<li style="color:#999; padding:0.3rem 0.6rem;">Last</li>';
    echo '</ul></nav>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>MwalimuLink™ - Administrator Portal</title>
<script type="module" src="https://cdn.jsdelivr.net/npm/@shoelace-style/shoelace@2.13.0/dist/shoelace.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@shoelace-style/shoelace@2.13.0/dist/themes/light.css" />
<script src="https://unpkg.com/htmx.org@1.9.2"></script>
<style>
  body {
    background:#f8f9fa;
    font-family: system-ui, sans-serif;
    margin: 2em auto;
    max-width: 900px;
  }
  main {
    background: white;
    padding: 2em;
    border-radius: 8px;
    box-shadow: 0 3px 10px #00000020;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 1em;
  }
  th, td {
    border: 1px solid #ddd;
    padding: 0.4em 0.6em;
    max-width: 200px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
  }
  th {
    background: #f0f0f0;
  }
  nav a {
    margin-right: 1em;
  }
  form.search-form {
    margin-top: 1em;
  }
</style>
</head>
<body>
<main>
  <h1>MwalimuLink™ - Administrator Portal</h1>

  <sl-select label="Select Table" placeholder="Choose a table" id="tableSelect" style="width:100%; max-width:400px;" hx-get="?" hx-target="#tableActions" hx-vals='{"table": this.value, "action": "list"}' hx-trigger="sl-change">
    <sl-option value="">-- Select Table --</sl-option>
    <?php foreach ($tables as $t): ?>
      <sl-option value="<?=h($t)?>" <?= $t === $table ? 'selected' : '' ?>><?=h($t)?></sl-option>
    <?php endforeach; ?>
  </sl-select>

  <div id="tableActions" style="margin-top:1.5em;">
  <?php if ($table === ''): ?>
    <p>Please select a table to manage.</p>
  <?php else: ?>
    <?php if ($message): ?>
      <p><?= $message ?></p>
    <?php endif; ?>

    <?php if ($action === 'list'): ?>
      <h2>Table: <?=h($table)?></h2>

      <nav style="margin-bottom:1em;">
        <a href="?table=<?=h($table)?>&action=create" is="sl-button" variant="primary">Create New Record</a>
        <sl-button variant="success" onclick="exportTable('csv')">Export CSV</sl-button>
        <sl-button variant="success" onclick="exportTable('excel')">Export Excel</sl-button>
        <sl-button variant="neutral" onclick="showSchema()">View Schema</sl-button>
      </nav>

      <form method="get" class="search-form" action="">
        <input type="hidden" name="table" value="<?=h($table)?>">
        <input type="hidden" name="action" value="list">
        <sl-input name="search" value="<?=h($search)?>" placeholder="Search in text fields..."></sl-input>
        <sl-button type="submit" variant="primary" style="margin-top:0.5em;">Filter</sl-button>
        <?php if ($search !== ''): ?>
          <a href="?table=<?=h($table)?>&action=list">Clear</a>
        <?php endif; ?>
      </form>

      <?php
      // Build search WHERE clause
      $where = '';
      $params = [];
      if ($search !== '') {
          $columns = R::getColumns($table);
          $textColumns = [];
          foreach ($columns as $col => $type) {
              if (stripos($type, 'char') !== false || stripos($type, 'text') !== false) {
                  $textColumns[] = $col;
              }
          }
          if ($textColumns) {
              $likeClauses = [];
              foreach ($textColumns as $col) {
                  $likeClauses[] = "$col LIKE ?";
                  $params[] = '%' . $search . '%';
              }
              $where = 'WHERE ' . implode(' OR ', $likeClauses);
          }
      }

      $total = $where ? R::count($table, $where, $params) : R::count($table);
      $offset = ($page - 1) * $per_page;
      $records = $where
          ? R::findAll($table, "$where LIMIT ? OFFSET ?", array_merge($params, [$per_page, $offset]))
          : R::findAll($table, 'LIMIT ? OFFSET ?', [$per_page, $offset]);

      if ($total === 0) {
          echo "<p>No records found.</p>";
      } else {
          echo '<table><thead><tr>';
          $first = reset($records);
          if ($first) {
              $cols = array_keys((array)$first->export());
              $cols_to_show = array_slice($cols, 0, 3);
              foreach ($cols_to_show as $col) {
                  echo '<th>' . h($col) . '</th>';
              }
              echo '<th>Actions</th></tr></thead><tbody>';
              foreach ($records as $record) {
                  echo '<tr>';
                  foreach ($cols_to_show as $col) {
                      $val = $record->$col;
                      echo '<td title="' . h($val) . '">' . h($val) . '</td>';
                  }
                  echo '<td>';
                  echo '<a href="?table=' . h($table) . '&action=details&id=' . $record->id . '">Details</a> | ';
                  echo '<a href="?table=' . h($table) . '&action=update&id=' . $record->id . '">Edit</a> | ';
                  echo '<a href="?table=' . h($table) . '&action=delete&id=' . $record->id . '">Delete</a>';
                  echo '</td></tr>';
              }
              echo '</tbody></table>';

              $base_url = "?table=" . urlencode($table) . "&action=list";
              if ($search !== '') {
                  $base_url .= "&search=" . urlencode($search);
              }
              paginate($total, $per_page, $page, $base_url);
          }
      }
      ?>

    <?php elseif ($action === 'details' && isset($_GET['id'])): ?>
      <?php
      $id = (int)$_GET['id'];
      $bean = R::load($table, $id);
      if (!$bean->id) {
          echo "<p>Record not found.</p>";
      } else {
          echo "<h2>Details of Record #" . h($id) . " in " . h($table) . "</h2>";
          echo '<table>';
          foreach ($bean as $col => $val) {
              echo '<tr><th>' . h($col) . '</th><td>' . nl2br(h($val)) . '</td></tr>';
          }
          echo '</table>';
          echo '<p><a href="?table=' . h($table) . '&action=list">Back to list</a></p>';
      }
      ?>

    <?php elseif ($action === 'create'): ?>
      <h2>Create New Record in <?=h($table)?></h2>
      <form method="post" action="?table=<?=h($table)?>&action=create">
        <?php
        $columns = R::inspect($table);
        foreach ($columns as $col => $type):
          if ($col === 'id') continue;
        ?>
          <label for="<?=h($col)?>"><?=h($col)?></label>
          <sl-input type="text" id="<?=h($col)?>" name="<?=h($col)?>" required></sl-input>
        <?php endforeach; ?>
        <sl-button type="submit" variant="primary" style="margin-top:1em;">Create</sl-button>
        <a href="?table=<?=h($table)?>&action=list">Cancel</a>
      </form>

    <?php elseif ($action === 'update' && isset($_GET['id'])): ?>
      <?php
      $id = (int)$_GET['id'];
      $bean = R::load($table, $id);
      if (!$bean->id) {
          echo "<p>Record not found.</p>";
      } else {
      ?>
      <h2>Update Record #<?=h($id)?> in <?=h($table)?></h2>
      <form method="post" action="?table=<?=h($table)?>&action=update&id=<?=h($id)?>">
        <input type="hidden" name="id" value="<?=h($id)?>">
        <?php foreach ($bean as $col => $val):
          if ($col === 'id') continue;
        ?>
          <label for="<?=h($col)?>"><?=h($col)?></label>
          <sl-input type="text" id="<?=h($col)?>" name="<?=h($col)?>" value="<?=h($val)?>" required></sl-input>
        <?php endforeach; ?>
        <sl-button type="submit" variant="primary" style="margin-top:1em;">Update</sl-button>
        <a href="?table=<?=h($table)?>&action=list">Cancel</a>
      </form>
      <?php } ?>

    <?php elseif ($action === 'delete' && isset($_GET['id'])): ?>
      <?php
      $id = (int)$_GET['id'];
      $bean = R::load($table, $id);
      if (!$bean->id) {
          echo "<p>Record not found.</p>";
      } else {
      ?>
      <h2>Delete Record #<?=h($id)?> in <?=h($table)?></h2>
      <form method="post" action="?table=<?=h($table)?>&action=delete&id=<?=h($id)?>">
        <input type="hidden" name="id" value="<?=h($id)?>">
        <p>Are you sure you want to delete this record?</p>
        <sl-button type="submit" variant="danger">Delete</sl-button>
        <a href="?table=<?=h($table)?>&action=list">Cancel</a>
      </form>
      <?php } ?>

    <?php else: ?>
      <p>Unknown action.</p>
    <?php endif; ?>
  <?php endif; ?>
  </div>
</main>

<!-- Schema modal -->
<sl-dialog label="Table Schema" id="schemaModal" style="min-width:400px;">
  <pre id="schemaContent" style="white-space: pre-wrap; max-height: 400px; overflow-y: auto;"></pre>
  <sl-button slot="footer" variant="primary" onclick="document.getElementById('schemaModal').hide()">Close</sl-button>
</sl-dialog>

<script>
  function showSchema() {
    const table = document.getElementById('tableSelect').value;
    if (!table) return alert('Select a table first.');
    fetch(`?table=${encodeURIComponent(table)}&action=schema`)
      .then(res => res.text())
      .then(data => {
        document.getElementById('schemaContent').textContent = data;
        document.getElementById('schemaModal').show();
      });
  }

  function exportTable(type) {
    const table = document.getElementById('tableSelect').value;
    if (!table) return alert('Select a table first.');
    window.location.href = `export.php?table=${encodeURIComponent(table)}&type=${type}`;
  }
</script>

<?php
// Handle schema display (ajax)
if ($action === 'schema' && $table) {
    $columns = R::getColumns($table);
    header('Content-Type: text/plain; charset=utf-8');
    foreach ($columns as $col => $type) {
        echo "$col : $type\n";
    }
    exit;
}
?>

</body>
</html>
